/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.render.vertex.VertexBufferWriter;
import me.jellysquid.mods.sodium.client.render.vertex.formats.ModelVertex;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.world.biome.ItemColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ItemRenderer.class})
public class MixinItemRenderer {
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    @Shadow
    @Final
    private ItemColors f_115097_;

    @Overwrite
    public void m_115189_(BakedModel model, ItemStack itemStack, int light, int overlay, PoseStack matricStack, VertexConsumer vertexConsumer) {
        VertexBufferWriter writer = VertexBufferWriter.of(vertexConsumer);
        RandomSource random = this.random;
        PoseStack.Pose matrices = matricStack.m_85850_();
        ItemColor colorProvider = null;
        if (!itemStack.m_41619_()) {
            colorProvider = ((ItemColorsExtended)this.f_115097_).getColorProvider(itemStack);
        }
        for (Direction direction : DirectionUtil.ALL_DIRECTIONS) {
            random.m_188584_(42L);
            List quads = model.m_213637_(null, direction, random);
            if (quads.isEmpty()) continue;
            this.sodium$renderBakedItemQuads(matrices, writer, quads, itemStack, colorProvider, light, overlay);
        }
        random.m_188584_(42L);
        List quads = model.m_213637_(null, null, random);
        if (!quads.isEmpty()) {
            this.sodium$renderBakedItemQuads(matrices, writer, quads, itemStack, colorProvider, light, overlay);
        }
    }

    private void sodium$renderBakedItemQuads(PoseStack.Pose matrices, VertexBufferWriter writer, List<BakedQuad> quads, ItemStack itemStack, ItemColor colorProvider, int light, int overlay) {
        for (int j = 0; j < quads.size(); ++j) {
            BakedQuad bakedQuad = quads.get(j);
            int color = -1;
            if (colorProvider != null && bakedQuad.m_111304_()) {
                color = ColorARGB.toABGR(colorProvider.m_92671_(itemStack, bakedQuad.m_111305_()), 255);
            }
            ModelQuadView quad = (ModelQuadView)bakedQuad;
            ModelVertex.writeQuadVertices(writer, matrices, quad, light, overlay, color);
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
    }
}

