/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.vertex.transform;

import com.mojang.blaze3d.vertex.VertexConsumer;
import me.jellysquid.mods.sodium.client.render.vertex.VertexBufferWriter;
import me.jellysquid.mods.sodium.client.render.vertex.VertexFormatDescription;
import me.jellysquid.mods.sodium.client.render.vertex.transform.CommonVertexElement;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.UnsafeUtil;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class VertexTransform {
    public static void transformSprite(long ptr, int count, VertexFormatDescription format, float minU, float minV, float maxU, float maxV) {
        long stride = format.stride;
        long offsetUV = format.getOffset(CommonVertexElement.TEXTURE);
        float w = maxU - minU;
        float h = maxV - minV;
        for (int vertexIndex = 0; vertexIndex < count; ++vertexIndex) {
            float u = MemoryUtil.memGetFloat((long)(ptr + offsetUV + 0L));
            float v = MemoryUtil.memGetFloat((long)(ptr + offsetUV + 4L));
            float ut = minU + w * u;
            float vt = minV + h * v;
            MemoryUtil.memPutFloat((long)(ptr + offsetUV + 0L), (float)ut);
            MemoryUtil.memPutFloat((long)(ptr + offsetUV + 4L), (float)vt);
            ptr += stride;
        }
    }

    public static void transformColor(long ptr, int count, VertexFormatDescription format, int color) {
        int offsetColor = format.getOffset(CommonVertexElement.COLOR);
        for (int vertexIndex = 0; vertexIndex < count; ++vertexIndex) {
            MemoryUtil.memPutInt((long)(ptr + (long)offsetColor), (int)color);
            ptr += (long)format.stride;
        }
    }

    public static void transformOverlay(long ptr, int count, VertexFormatDescription format, Matrix3f inverseNormalMatrix, Matrix4f inverseTextureMatrix, float textureScale) {
        int offsetPosition = format.getOffset(CommonVertexElement.POSITION);
        int offsetColor = format.getOffset(CommonVertexElement.COLOR);
        int offsetNormal = format.getOffset(CommonVertexElement.NORMAL);
        int offsetTexture = format.getOffset(CommonVertexElement.TEXTURE);
        int color = ColorABGR.pack(1.0f, 1.0f, 1.0f, 1.0f);
        Vector3f normal = new Vector3f(Float.NaN);
        Vector4f position = new Vector4f(Float.NaN);
        for (int vertexIndex = 0; vertexIndex < count; ++vertexIndex) {
            position.x = MemoryUtil.memGetFloat((long)(ptr + (long)offsetPosition + 0L));
            position.y = MemoryUtil.memGetFloat((long)(ptr + (long)offsetPosition + 4L));
            position.z = MemoryUtil.memGetFloat((long)(ptr + (long)offsetPosition + 8L));
            position.w = 1.0f;
            int packedNormal = MemoryUtil.memGetInt((long)(ptr + (long)offsetNormal));
            normal.x = Norm3b.unpackX(packedNormal);
            normal.y = Norm3b.unpackY(packedNormal);
            normal.z = Norm3b.unpackZ(packedNormal);
            Vector3f transformedNormal = inverseNormalMatrix.transform(normal);
            Direction direction = Direction.m_122372_((float)transformedNormal.x(), (float)transformedNormal.y(), (float)transformedNormal.z());
            Vector4f transformedTexture = inverseTextureMatrix.transform(position);
            transformedTexture.rotateY((float)Math.PI);
            transformedTexture.rotateX(-1.5707964f);
            transformedTexture.rotate((Quaternionfc)direction.m_253075_());
            float textureU = -transformedTexture.x() * textureScale;
            float textureV = -transformedTexture.y() * textureScale;
            MemoryUtil.memPutInt((long)(ptr + (long)offsetColor), (int)color);
            MemoryUtil.memPutFloat((long)(ptr + (long)offsetTexture + 0L), (float)textureU);
            MemoryUtil.memPutFloat((long)(ptr + (long)offsetTexture + 4L), (float)textureV);
            ptr += (long)format.stride;
        }
    }

    public static void copyPush(VertexConsumer consumer, MemoryStack stack, long ptr, int count, VertexFormatDescription format) {
        int length = count * format.stride;
        long copy = stack.nmalloc(length);
        UnsafeUtil.copyMemory(ptr, copy, length);
        VertexBufferWriter.of(consumer).push(stack, copy, count, format);
    }
}

