/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.vertex;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import me.jellysquid.mods.sodium.client.render.vertex.transform.CommonVertexElement;

public class VertexFormatDescription {
    private final VertexFormat format;
    public final int id;
    public final int stride;
    public final int elementCount;
    public final int[] elementOffsets;

    public VertexFormatDescription(VertexFormat format, int id) {
        this.format = format;
        this.id = id;
        this.stride = format.m_86020_();
        this.elementCount = format.m_86023_().size();
        this.elementOffsets = CommonVertexElement.getOffsets(format);
    }

    public List<VertexFormatElement> getElements() {
        return this.format.m_86023_();
    }

    public IntList getOffsets() {
        return IntLists.unmodifiable((IntList)this.format.f_86013_);
    }

    public int getOffset(CommonVertexElement element) {
        int offset = this.elementOffsets[element.ordinal()];
        if (offset == -1) {
            throw new NoSuchElementException("Vertex format does not contain element: " + String.valueOf((Object)element));
        }
        return offset;
    }

    public String toString() {
        return this.getElements().stream().map(e -> String.format("[%s]", e)).collect(Collectors.joining(","));
    }
}

