/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.data;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.texture.SpriteExtended;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChunkRenderData {
    public static final ChunkRenderData ABSENT = new Builder().build();
    public static final ChunkRenderData EMPTY = ChunkRenderData.createEmptyData();
    private List<BlockEntity> globalBlockEntities;
    private List<BlockEntity> blockEntities;
    private VisibilitySet occlusionData;
    private ChunkRenderBounds bounds;
    private List<TextureAtlasSprite> animatedSprites;
    private boolean isEmpty;

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public ChunkRenderBounds getBounds() {
        return this.bounds;
    }

    public VisibilitySet getOcclusionData() {
        return this.occlusionData;
    }

    public List<TextureAtlasSprite> getAnimatedSprites() {
        return this.animatedSprites;
    }

    public Collection<BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public Collection<BlockEntity> getGlobalBlockEntities() {
        return this.globalBlockEntities;
    }

    private static ChunkRenderData createEmptyData() {
        VisibilitySet occlusionData = new VisibilitySet();
        occlusionData.m_112990_(EnumSet.allOf(Direction.class));
        Builder meshInfo = new Builder();
        meshInfo.setOcclusionData(occlusionData);
        return meshInfo.build();
    }

    public static class Builder {
        private final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
        private final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        private final Set<TextureAtlasSprite> animatedSprites = new ObjectOpenHashSet();
        private VisibilitySet occlusionData;
        private ChunkRenderBounds bounds = ChunkRenderBounds.ALWAYS_FALSE;

        public void setBounds(ChunkRenderBounds bounds) {
            this.bounds = bounds;
        }

        public void setOcclusionData(VisibilitySet data) {
            this.occlusionData = data;
        }

        public void addSprite(TextureAtlasSprite sprite) {
            if (((SpriteExtended)sprite.m_245424_()).hasAnimation()) {
                this.animatedSprites.add(sprite);
            }
        }

        public void addBlockEntity(BlockEntity entity, boolean cull) {
            (cull ? this.blockEntities : this.globalBlockEntities).add(entity);
        }

        public ChunkRenderData build() {
            ChunkRenderData data = new ChunkRenderData();
            data.globalBlockEntities = this.globalBlockEntities;
            data.blockEntities = this.blockEntities;
            data.occlusionData = this.occlusionData;
            data.bounds = this.bounds;
            data.animatedSprites = new ObjectArrayList(this.animatedSprites);
            data.isEmpty = this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty();
            return data;
        }
    }
}

