/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuad;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class FluidRenderer {
    private static final float EPSILON = 0.001f;
    private final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
    private final MutableFloat scratchHeight = new MutableFloat(0.0f);
    private final MutableInt scratchSamples = new MutableInt();
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final ColorBlender colorBlender;
    private final ForgeFluidColorizerAdapter forgeColorProviderAdapter = new ForgeFluidColorizerAdapter();
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();

    public FluidRenderer(LightPipelineProvider lighters, ColorBlender colorBlender) {
        this.quad.setNormal(Norm3b.pack(0.0f, 1.0f, 0.0f));
        this.lighters = lighters;
        this.colorBlender = colorBlender;
    }

    private boolean isFluidOccluded(BlockAndTintGetter world, int x, int y, int z, Direction dir, Fluid fluid) {
        BlockPos.MutableBlockPos pos = this.scratchPos.m_122178_(x, y, z);
        BlockState blockState = world.m_8055_((BlockPos)pos);
        BlockPos.MutableBlockPos adjPos = this.scratchPos.m_122178_(x + dir.m_122429_(), y + dir.m_122430_(), z + dir.m_122431_());
        if (blockState.m_60815_()) {
            return world.m_6425_((BlockPos)adjPos).m_76152_().m_6212_(fluid) || blockState.m_60659_((BlockGetter)world, (BlockPos)pos, dir, SupportType.FULL);
        }
        return world.m_6425_((BlockPos)adjPos).m_76152_().m_6212_(fluid);
    }

    private boolean isSideExposed(BlockAndTintGetter world, int x, int y, int z, Direction dir, float height) {
        BlockPos.MutableBlockPos pos = this.scratchPos.m_122178_(x + dir.m_122429_(), y + dir.m_122430_(), z + dir.m_122431_());
        BlockState blockState = world.m_8055_((BlockPos)pos);
        if (blockState.m_60815_()) {
            VoxelShape shape = blockState.m_60768_((BlockGetter)world, (BlockPos)pos);
            if (shape == Shapes.m_83144_()) {
                return dir == Direction.UP;
            }
            if (shape.m_83281_()) {
                return true;
            }
            VoxelShape threshold = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            return !Shapes.m_83117_((VoxelShape)threshold, (VoxelShape)shape, (Direction)dir);
        }
        return true;
    }

    public boolean render(BlockAndTintGetter world, FluidState fluidState, BlockPos pos, BlockPos offset, ChunkModelBuilder buffers) {
        float h4;
        float h3;
        float h2;
        float h1;
        int posX = pos.m_123341_();
        int posY = pos.m_123342_();
        int posZ = pos.m_123343_();
        Fluid fluid = fluidState.m_76152_();
        boolean sfUp = this.isFluidOccluded(world, posX, posY, posZ, Direction.UP, fluid);
        boolean sfDown = this.isFluidOccluded(world, posX, posY, posZ, Direction.DOWN, fluid) || !this.isSideExposed(world, posX, posY, posZ, Direction.DOWN, 0.8888889f);
        boolean sfNorth = this.isFluidOccluded(world, posX, posY, posZ, Direction.NORTH, fluid);
        boolean sfSouth = this.isFluidOccluded(world, posX, posY, posZ, Direction.SOUTH, fluid);
        boolean sfWest = this.isFluidOccluded(world, posX, posY, posZ, Direction.WEST, fluid);
        boolean sfEast = this.isFluidOccluded(world, posX, posY, posZ, Direction.EAST, fluid);
        if (sfUp && sfDown && sfEast && sfWest && sfNorth && sfSouth) {
            return false;
        }
        boolean isWater = fluidState.m_205070_(FluidTags.f_13131_);
        ColorSampler<FluidState> colorizer = this.createColorProviderAdapter(world, pos, fluidState);
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)world, (BlockPos)pos, (FluidState)fluidState);
        boolean rendered = false;
        float fluidHeight = this.fluidHeight(world, fluid, pos);
        if (fluidHeight >= 1.0f) {
            h1 = 1.0f;
            h2 = 1.0f;
            h3 = 1.0f;
            h4 = 1.0f;
        } else {
            float north1 = this.fluidHeight(world, fluid, pos.m_122012_());
            float south1 = this.fluidHeight(world, fluid, pos.m_122019_());
            float east1 = this.fluidHeight(world, fluid, pos.m_122029_());
            float west1 = this.fluidHeight(world, fluid, pos.m_122024_());
            h1 = this.fluidCornerHeight(world, fluid, fluidHeight, north1, west1, pos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST));
            h2 = this.fluidCornerHeight(world, fluid, fluidHeight, south1, west1, pos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST));
            h3 = this.fluidCornerHeight(world, fluid, fluidHeight, south1, east1, pos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST));
            h4 = this.fluidCornerHeight(world, fluid, fluidHeight, north1, east1, pos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST));
        }
        float yOffset = sfDown ? 0.0f : 0.001f;
        ModelQuadViewMutable quad = this.quad;
        LightMode lightMode = isWater && Minecraft.m_91086_() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        if (!sfUp && this.isSideExposed(world, posX, posY, posZ, Direction.UP, Math.min(Math.min(h1, h2), Math.min(h3, h4)))) {
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            ModelQuadFacing facing;
            TextureAtlasSprite sprite;
            h1 -= 0.001f;
            h2 -= 0.001f;
            h3 -= 0.001f;
            h4 -= 0.001f;
            Vec3 velocity = fluidState.m_76179_((BlockGetter)world, pos);
            if (velocity.f_82479_ == 0.0 && velocity.f_82481_ == 0.0) {
                sprite = sprites[0];
                facing = ModelQuadFacing.UP;
                u1 = sprite.m_118367_(0.0);
                v1 = sprite.m_118393_(0.0);
                u2 = u1;
                v2 = sprite.m_118393_(16.0);
                u3 = sprite.m_118367_(16.0);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                facing = ModelQuadFacing.UNASSIGNED;
                float dir = (float)Mth.m_14136_((double)velocity.f_82481_, (double)velocity.f_82479_) - 1.5707964f;
                float sin = Mth.m_14031_((float)dir) * 0.25f;
                float cos = Mth.m_14089_((float)dir) * 0.25f;
                u1 = sprite.m_118367_((double)(8.0f + (-cos - sin) * 16.0f));
                v1 = sprite.m_118393_((double)(8.0f + (-cos + sin) * 16.0f));
                u2 = sprite.m_118367_((double)(8.0f + (-cos + sin) * 16.0f));
                v2 = sprite.m_118393_((double)(8.0f + (cos + sin) * 16.0f));
                u3 = sprite.m_118367_((double)(8.0f + (cos + sin) * 16.0f));
                v3 = sprite.m_118393_((double)(8.0f + (cos - sin) * 16.0f));
                u4 = sprite.m_118367_((double)(8.0f + (cos - sin) * 16.0f));
                v4 = sprite.m_118393_((double)(8.0f + (-cos - sin) * 16.0f));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s1 = (float)sprites[0].m_245424_().m_246492_() / (sprites[0].m_118410_() - sprites[0].m_118409_());
            float s2 = (float)sprites[0].m_245424_().m_245330_() / (sprites[0].m_118412_() - sprites[0].m_118411_());
            float s3 = 4.0f / Math.max(s2, s1);
            u1 = Mth.m_14179_((float)s3, (float)u1, (float)uAvg);
            u2 = Mth.m_14179_((float)s3, (float)u2, (float)uAvg);
            u3 = Mth.m_14179_((float)s3, (float)u3, (float)uAvg);
            u4 = Mth.m_14179_((float)s3, (float)u4, (float)uAvg);
            v1 = Mth.m_14179_((float)s3, (float)v1, (float)vAvg);
            v2 = Mth.m_14179_((float)s3, (float)v2, (float)vAvg);
            v3 = Mth.m_14179_((float)s3, (float)v3, (float)vAvg);
            v4 = Mth.m_14179_((float)s3, (float)v4, (float)vAvg);
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, 0.0f, h1, 0.0f, u1, v1);
            FluidRenderer.setVertex(quad, 1, 0.0f, h2, 1.0f, u2, v2);
            FluidRenderer.setVertex(quad, 2, 1.0f, h3, 1.0f, u3, v3);
            FluidRenderer.setVertex(quad, 3, 1.0f, h4, 0.0f, u4, v4);
            this.updateQuad(quad, world, pos, lighter, Direction.UP, 1.0f, colorizer, fluidState);
            this.writeQuad(buffers, offset, quad, facing, ModelQuadWinding.CLOCKWISE);
            if (fluidState.m_76171_((BlockGetter)world, (BlockPos)this.scratchPos.m_122178_(posX, posY + 1, posZ))) {
                this.writeQuad(buffers, offset, quad, ModelQuadFacing.DOWN, ModelQuadWinding.COUNTERCLOCKWISE);
            }
            rendered = true;
        }
        if (!sfDown) {
            TextureAtlasSprite sprite = sprites[0];
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118411_();
            float maxV = sprite.m_118412_();
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
            FluidRenderer.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
            FluidRenderer.setVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
            FluidRenderer.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
            this.updateQuad(quad, world, pos, lighter, Direction.DOWN, 1.0f, colorizer, fluidState);
            this.writeQuad(buffers, offset, quad, ModelQuadFacing.DOWN, ModelQuadWinding.CLOCKWISE);
            rendered = true;
        }
        quad.setFlags(4);
        block6: for (Direction dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            BlockPos.MutableBlockPos adjPos;
            BlockState adjBlock;
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case NORTH: {
                    if (sfNorth) continue block6;
                    c1 = h1;
                    c2 = h4;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case SOUTH: {
                    if (sfSouth) continue block6;
                    c1 = h3;
                    c2 = h2;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case WEST: {
                    if (sfWest) continue block6;
                    c1 = h2;
                    c2 = h1;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case EAST: {
                    if (sfEast) continue block6;
                    c1 = h4;
                    c2 = h3;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(world, posX, posY, posZ, dir, Math.max(c1, c2))) continue;
            int adjX = posX + dir.m_122429_();
            int adjY = posY + dir.m_122430_();
            int adjZ = posZ + dir.m_122431_();
            TextureAtlasSprite sprite = sprites[1];
            boolean isOverlay = false;
            if (sprites.length > 2 && !(adjBlock = world.m_8055_((BlockPos)(adjPos = this.scratchPos.m_122178_(adjX, adjY, adjZ)))).m_60815_() && !adjBlock.m_60795_()) {
                sprite = sprites[2];
                if (sprite != null) {
                    isOverlay = true;
                } else {
                    sprite = sprites[1];
                }
            }
            float u1 = sprite.m_118367_(0.0);
            float u2 = sprite.m_118367_(8.0);
            float v1 = sprite.m_118393_((double)((1.0f - c1) * 16.0f * 0.5f));
            float v2 = sprite.m_118393_((double)((1.0f - c2) * 16.0f * 0.5f));
            float v3 = sprite.m_118393_(8.0);
            quad.setSprite(sprite);
            FluidRenderer.setVertex(quad, 0, x2, c2, z2, u2, v2);
            FluidRenderer.setVertex(quad, 1, x2, yOffset, z2, u2, v3);
            FluidRenderer.setVertex(quad, 2, x1, yOffset, z1, u1, v3);
            FluidRenderer.setVertex(quad, 3, x1, c1, z1, u1, v1);
            float br = dir.m_122434_() == Direction.Axis.Z ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection(dir);
            this.updateQuad(quad, world, pos, lighter, dir, br, colorizer, fluidState);
            this.writeQuad(buffers, offset, quad, facing, ModelQuadWinding.CLOCKWISE);
            if (!isOverlay) {
                this.writeQuad(buffers, offset, quad, facing.getOpposite(), ModelQuadWinding.COUNTERCLOCKWISE);
            }
            rendered = true;
        }
        return rendered;
    }

    private ColorSampler<FluidState> createColorProviderAdapter(BlockAndTintGetter view, BlockPos pos, FluidState state) {
        ForgeFluidColorizerAdapter adapter = this.forgeColorProviderAdapter;
        adapter.setHandler(view, pos, state);
        return adapter;
    }

    private void updateQuad(ModelQuadView quad, BlockAndTintGetter world, BlockPos pos, LightPipeline lighter, Direction dir, float brightness, ColorSampler<FluidState> colorSampler, FluidState fluidState) {
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, null, dir, false);
        int[] biomeColors = this.colorBlender.getColors(world, pos, quad, colorSampler, fluidState);
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorABGR.mul(biomeColors != null ? biomeColors[i] : -1, light.br[i] * brightness);
        }
    }

    private void writeQuad(ChunkModelBuilder builder, BlockPos offset, ModelQuadView quad, ModelQuadFacing facing, ModelQuadWinding winding) {
        ChunkVertexBufferBuilder vertexBuffer = builder.getVertexBuffer();
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex out = vertices[i];
            out.x = (float)offset.m_123341_() + quad.getX(i);
            out.y = (float)offset.m_123342_() + quad.getY(i);
            out.z = (float)offset.m_123343_() + quad.getZ(i);
            out.color = this.quadColors[i];
            out.u = quad.getTexU(i);
            out.v = quad.getTexV(i);
            out.light = this.quadLightData.lm[i];
        }
        TextureAtlasSprite sprite = quad.getSprite();
        if (sprite != null) {
            builder.addSprite(sprite);
        }
        builder.getIndexBuffer(facing).add(vertexBuffer.push(vertices), winding);
    }

    private static void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float fluidCornerHeight(BlockAndTintGetter world, Fluid fluid, float fluidHeight, float fluidHeightX, float fluidHeightY, BlockPos blockPos) {
        if (fluidHeightY >= 1.0f || fluidHeightX >= 1.0f) {
            return 1.0f;
        }
        if (fluidHeightY > 0.0f || fluidHeightX > 0.0f) {
            float height = this.fluidHeight(world, fluid, blockPos);
            if (height >= 1.0f) {
                return 1.0f;
            }
            this.modifyHeight(this.scratchHeight, this.scratchSamples, height);
        }
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeight);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightY);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightX);
        float result = this.scratchHeight.floatValue() / (float)this.scratchSamples.intValue();
        this.scratchHeight.setValue(0.0f);
        this.scratchSamples.setValue(0);
        return result;
    }

    private void modifyHeight(MutableFloat totalHeight, MutableInt samples, float target) {
        if (target >= 0.8f) {
            totalHeight.add(target * 10.0f);
            samples.add(10);
        } else if (target >= 0.0f) {
            totalHeight.add(target);
            samples.increment();
        }
    }

    private float fluidHeight(BlockAndTintGetter world, Fluid fluid, BlockPos blockPos) {
        BlockState blockState = world.m_8055_(blockPos);
        FluidState fluidState = blockState.m_60819_();
        if (fluid.m_6212_(fluidState.m_76152_())) {
            FluidState fluidStateUp = world.m_6425_(blockPos.m_7494_());
            if (fluid.m_6212_(fluidStateUp.m_76152_())) {
                return 1.0f;
            }
            return fluidState.m_76182_();
        }
        if (!blockState.m_60767_().m_76333_()) {
            return 0.0f;
        }
        return -1.0f;
    }

    private static class ForgeFluidColorizerAdapter
    implements ColorSampler<FluidState> {
        private BlockAndTintGetter world;
        private BlockPos pos;
        private FluidState state;

        private ForgeFluidColorizerAdapter() {
        }

        public void setHandler(BlockAndTintGetter world, BlockPos pos, FluidState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }

        @Override
        public int getColor(FluidState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
            if (this.world == null || this.state == null) {
                return -1;
            }
            return IClientFluidTypeExtensions.of((FluidState)state).getTintColor(state, world, pos);
        }
    }
}

