/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.util.color.ColorMixer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;

public class LinearColorBlender
implements ColorBlender {
    private final int[] cachedRet = new int[4];
    private final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();

    @Override
    public <T> int[] getColors(BlockAndTintGetter world, BlockPos origin, ModelQuadView quad, ColorSampler<T> sampler, T state) {
        int[] colors = this.cachedRet;
        for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
            colors[vertexIndex] = this.getVertexColor(world, origin, quad, sampler, state, vertexIndex);
        }
        return colors;
    }

    private <T> int getBlockColor(BlockAndTintGetter world, T state, ColorSampler<T> sampler, int x, int y, int z, int colorIdx) {
        return sampler.getColor(state, world, (BlockPos)this.mpos.m_122178_(x, y, z), colorIdx);
    }

    private <T> int getVertexColor(BlockAndTintGetter world, BlockPos origin, ModelQuadView quad, ColorSampler<T> sampler, T state, int vertexIdx) {
        float x = Mth.m_14036_((float)quad.getX(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        float y = Mth.m_14036_((float)quad.getY(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        float z = Mth.m_14036_((float)quad.getZ(vertexIdx), (float)-1.0f, (float)2.0f) - 0.5f;
        int intX = (int)Math.floor(x);
        int intY = (int)Math.floor(y);
        int intZ = (int)Math.floor(z);
        int originX = origin.m_123341_() + intX;
        int originY = origin.m_123342_() + intY;
        int originZ = origin.m_123343_() + intZ;
        int c00 = this.getBlockColor(world, state, sampler, originX, originY, originZ, quad.getColorIndex());
        int c01 = this.getBlockColor(world, state, sampler, originX, originY, originZ + 1, quad.getColorIndex());
        int c10 = this.getBlockColor(world, state, sampler, originX + 1, originY, originZ, quad.getColorIndex());
        int c11 = this.getBlockColor(world, state, sampler, originX + 1, originY, originZ + 1, quad.getColorIndex());
        float fracX = x - (float)intX;
        float fracZ = z - (float)intZ;
        int dz1 = ColorMixer.getStartRatio(fracZ);
        int dz2 = ColorMixer.getEndRatio(fracZ);
        int rz0 = ColorMixer.mix(c00, c01, dz1, dz2);
        int rz1 = ColorMixer.mix(c10, c11, dz1, dz2);
        int dx1 = ColorMixer.getStartRatio(fracX);
        int dx2 = ColorMixer.getEndRatio(fracX);
        int rx = ColorMixer.mix(rz0, rz1, dx1, dx2);
        return ColorARGB.toABGR(rx);
    }
}

