/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWidget
implements Renderable,
GuiEventListener,
NarratableEntry {
    protected final Font font;
    protected boolean focused;
    protected boolean hovered;

    protected AbstractWidget() {
        this.font = Minecraft.m_91087_().f_91062_;
    }

    protected void drawString(PoseStack matrixStack, String str, int x, int y, int color) {
        this.font.m_92883_(matrixStack, str, (float)x, (float)y, color);
    }

    protected void drawString(PoseStack matrixStack, Component text, int x, int y, int color) {
        this.font.m_92889_(matrixStack, text, (float)x, (float)y, color);
    }

    public boolean isHovered() {
        return this.hovered;
    }

    protected void drawRect(double x1, double y1, double x2, double y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.drawQuads(vertices -> AbstractWidget.addQuad(vertices, x1, y1, x2, y2, a, r, g, b));
    }

    protected void drawQuads(Consumer<VertexConsumer> consumer) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        consumer.accept((VertexConsumer)bufferBuilder);
        BufferBuilder.RenderedBuffer output = bufferBuilder.m_231175_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)output);
        RenderSystem.m_69461_();
    }

    protected static void addQuad(VertexConsumer consumer, double x1, double y1, double x2, double y2, float a, float r, float g, float b) {
        consumer.m_5483_(x2, y1, 0.0).m_85950_(r, g, b, a).m_5752_();
        consumer.m_5483_(x1, y1, 0.0).m_85950_(r, g, b, a).m_5752_();
        consumer.m_5483_(x1, y2, 0.0).m_85950_(r, g, b, a).m_5752_();
        consumer.m_5483_(x2, y2, 0.0).m_85950_(r, g, b, a).m_5752_();
    }

    protected void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f));
    }

    protected int getStringWidth(String text) {
        return this.font.m_92895_(text);
    }

    protected int getStringWidth(FormattedText text) {
        return this.font.m_92852_(text);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        if (this.focused) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        if (this.hovered) {
            return NarratableEntry.NarrationPriority.HOVERED;
        }
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput builder) {
        if (this.focused) {
            builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.button.usage.focused"));
        } else if (this.hovered) {
            builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.button.usage.hovered"));
        }
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent navigation) {
        return !this.m_93696_() ? ComponentPath.m_264401_((GuiEventListener)this) : null;
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    protected void drawBorder(int x1, int y1, int x2, int y2) {
        this.drawRect(x1, y1, x2, y1 + 1, -1);
        this.drawRect(x1, y2 - 1, x2, y2, -1);
        this.drawRect(x1, y1, x1 + 1, y2, -1);
        this.drawRect(x2 - 1, y1, x2, y2, -1);
    }
}

