/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import com.mojang.blaze3d.vertex.PoseStack;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.renderer.Rect2i;

public class TickBoxControl
implements Control<Boolean> {
    private final Option<Boolean> option;

    public TickBoxControl(Option<Boolean> option) {
        this.option = option;
    }

    @Override
    public ControlElement<Boolean> createElement(Dim2i dim) {
        return new TickBoxControlElement(this.option, dim);
    }

    @Override
    public int getMaxWidth() {
        return 30;
    }

    @Override
    public Option<Boolean> getOption() {
        return this.option;
    }

    private static class TickBoxControlElement
    extends ControlElement<Boolean> {
        private final Rect2i button;

        public TickBoxControlElement(Option<Boolean> option, Dim2i dim) {
            super(option, dim);
            this.button = new Rect2i(dim.getLimitX() - 16, dim.getCenterY() - 5, 10, 10);
        }

        @Override
        public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float delta) {
            boolean ticked;
            super.m_86412_(matrixStack, mouseX, mouseY, delta);
            int x = this.button.m_110085_();
            int y = this.button.m_110086_();
            int w = x + this.button.m_110090_();
            int h = y + this.button.m_110091_();
            boolean enabled = this.option.isAvailable();
            boolean bl = ticked = enabled && (Boolean)this.option.getValue() != false;
            int color = enabled ? (ticked ? -7019309 : -1) : -5592406;
            if (ticked) {
                this.drawRect(x + 2, y + 2, w - 2, h - 2, color);
            }
            this.drawRectOutline(x, y, w, h, color);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
                this.toggleControl();
                this.playClickSound();
                return true;
            }
            return false;
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (!this.m_93696_()) {
                return false;
            }
            if (keyCode == 257) {
                this.toggleControl();
                this.playClickSound();
                return true;
            }
            return false;
        }

        public void toggleControl() {
            this.option.setValue((Boolean)this.option.getValue() == false);
        }

        protected void drawRectOutline(int x, int y, int w, int h, int color) {
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            this.drawQuads(vertices -> {
                TickBoxControlElement.addQuad(vertices, x, y, w, y + 1, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, x, h - 1, w, h, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, x, y, x + 1, h, a, r, g, b);
                TickBoxControlElement.addQuad(vertices, w - 1, y, w, h, a, r, g, b);
            });
        }
    }
}

