/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.loading.FMLPaths;

public class SodiumGameOptions {
    private static final String DEFAULT_FILE_NAME = "rubidium-options.json";
    public final QualitySettings quality = new QualitySettings();
    public final AdvancedSettings advanced = new AdvancedSettings();
    public final PerformanceSettings performance = new PerformanceSettings();
    public final NotificationSettings notifications = new NotificationSettings();
    private boolean readOnly;
    private Path configPath;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    public static SodiumGameOptions defaults() {
        SodiumGameOptions options = new SodiumGameOptions();
        options.configPath = SodiumGameOptions.getConfigPath(DEFAULT_FILE_NAME);
        options.sanitize();
        return options;
    }

    public static SodiumGameOptions load() {
        return SodiumGameOptions.load(DEFAULT_FILE_NAME);
    }

    public static SodiumGameOptions load(String name) {
        SodiumGameOptions config;
        Path path;
        block10: {
            path = SodiumGameOptions.getConfigPath(name);
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (SodiumGameOptions)GSON.fromJson((Reader)reader, SodiumGameOptions.class);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new SodiumGameOptions();
        }
        config.configPath = path;
        config.sanitize();
        try {
            config.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update config file", e);
        }
        return config;
    }

    private void sanitize() {
        if (this.advanced.arenaMemoryAllocator == null) {
            this.advanced.arenaMemoryAllocator = ArenaMemoryAllocator.ASYNC;
        }
    }

    private static Path getConfigPath(String name) {
        return FMLPaths.CONFIGDIR.get().resolve(name);
    }

    public void writeChanges() throws IOException {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Config file is read-only");
        }
        Path dir = this.configPath.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + String.valueOf(dir));
        }
        Path tempPath = this.configPath.resolveSibling(String.valueOf(this.configPath.getFileName()) + ".tmp");
        Files.writeString(tempPath, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        Files.move(tempPath, this.configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String getFileName() {
        return this.configPath.getFileName().toString();
    }

    public static class QualitySettings {
        public GraphicsQuality weatherQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality leavesQuality = GraphicsQuality.DEFAULT;
        public boolean enableVignette = true;
    }

    public static class AdvancedSettings {
        public ArenaMemoryAllocator arenaMemoryAllocator = null;
        public boolean allowDirectMemoryAccess = true;
        public boolean enableMemoryTracing = false;
        public boolean useAdvancedStagingBuffers = true;
        public int cpuRenderAheadLimit = 3;
    }

    public static class PerformanceSettings {
        public int chunkBuilderThreads = 0;
        public boolean alwaysDeferChunkUpdates = false;
        public boolean animateOnlyVisibleTextures = true;
        public boolean useEntityCulling = true;
        public boolean useFogOcclusion = true;
        public boolean useBlockFaceCulling = true;
    }

    public static class NotificationSettings {
        public boolean hideDonationButton = false;
    }

    public static enum ArenaMemoryAllocator implements TextProvider
    {
        ASYNC("sodium.options.chunk_memory_allocator.async"),
        SWAP("sodium.options.chunk_memory_allocator.swap");

        private final Component name;

        private ArenaMemoryAllocator(String name) {
            this.name = Component.m_237115_((String)name);
        }

        @Override
        public Component getLocalizedName() {
            return this.name;
        }
    }

    public static enum GraphicsQuality implements TextProvider
    {
        DEFAULT("options.gamma.default"),
        FANCY("options.clouds.fancy"),
        FAST("options.clouds.fast");

        private final Component name;

        private GraphicsQuality(String name) {
            this.name = Component.m_237115_((String)name);
        }

        @Override
        public Component getLocalizedName() {
            return this.name;
        }

        public boolean isFancy(GraphicsStatus graphicsMode) {
            return this == FANCY || this == DEFAULT && (graphicsMode == GraphicsStatus.FANCY || graphicsMode == GraphicsStatus.FABULOUS);
        }
    }
}

