/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.core.compat;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.CoreShaderBlacklist;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    Minecraft f_109059_;
    @Shadow
    @Final
    private Map<String, ShaderInstance> f_172578_;

    @Inject(method={"loadPrograms"}, at={@At(value="RETURN")})
    private void checkForCoreShaderModifications(ResourceProvider factory, CallbackInfo ci) {
        boolean modified = false;
        for (Map.Entry<String, ShaderInstance> shaderProgramEntry : this.f_172578_.entrySet()) {
            ResourceLocation vertexIdentifier;
            Resource resource;
            if (!CoreShaderBlacklist.isBlacklisted(shaderProgramEntry.getKey()) || (resource = (Resource)factory.m_213713_(vertexIdentifier = new ResourceLocation("shaders/core/" + shaderProgramEntry.getValue().m_108962_().m_85551_() + ".vsh")).orElse(null)) == null || resource.m_247173_().equals(this.f_109059_.m_246804_())) continue;
            modified = true;
            break;
        }
        if (modified && !ImmediatelyFast.config.experimental_disable_resource_pack_conflict_handling) {
            ImmediatelyFast.LOGGER.warn("Core shader modifications detected. Temporarily disabling some parts of ImmediatelyFast.");
            if (ImmediatelyFast.runtimeConfig.font_atlas_resizing) {
                ImmediatelyFast.runtimeConfig.font_atlas_resizing = false;
                this.immediatelyFast$reloadFontStorages();
            }
            ImmediatelyFast.runtimeConfig.hud_batching = false;
            ImmediatelyFast.runtimeConfig.universal_batching_text = false;
        } else {
            if (!ImmediatelyFast.runtimeConfig.font_atlas_resizing && ImmediatelyFast.config.font_atlas_resizing) {
                ImmediatelyFast.runtimeConfig.font_atlas_resizing = true;
                this.immediatelyFast$reloadFontStorages();
            }
            ImmediatelyFast.runtimeConfig.hud_batching = ImmediatelyFast.config.hud_batching;
            ImmediatelyFast.runtimeConfig.universal_batching_text = true;
        }
    }

    @Unique
    private void immediatelyFast$reloadFontStorages() {
        for (FontSet storage : Minecraft.m_91087_().f_91045_.f_94999_.values()) {
            ArrayList fonts = new ArrayList(storage.f_95055_);
            storage.f_95055_.clear();
            storage.m_95071_(fonts);
        }
    }
}

