/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.kubejs.util;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.BlockItemBuilder;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.compat.kubejs.util.AmmoNbtFactory;
import com.tacz.guns.compat.kubejs.util.AttachmentNbtFactory;
import com.tacz.guns.compat.kubejs.util.GunNbtFactory;
import com.tacz.guns.item.AmmoItem;
import com.tacz.guns.item.AttachmentItem;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TimelessItemWrapper {
    public static ItemStack gunItem(Consumer<GunNbtFactory> callback) {
        GunNbtFactory itemBuilder = new GunNbtFactory();
        callback.accept(itemBuilder);
        return itemBuilder.build();
    }

    public static ItemStack gunItem(Item item, Consumer<GunNbtFactory> callback) {
        GunNbtFactory gunNbtFactory;
        if (item instanceof AbstractGunItem) {
            AbstractGunItem gunItem = (AbstractGunItem)item;
            gunNbtFactory = new GunNbtFactory(gunItem);
        } else {
            gunNbtFactory = new GunNbtFactory();
        }
        GunNbtFactory itemBuilder = gunNbtFactory;
        callback.accept(itemBuilder);
        return itemBuilder.build();
    }

    public static ItemStack attachmentItem(Consumer<AttachmentItemBuilder> callback) {
        AttachmentItemBuilder itemBuilder = AttachmentItemBuilder.create();
        callback.accept(itemBuilder);
        return itemBuilder.build();
    }

    public static ItemStack attachmentItem(Item item, Consumer<AttachmentNbtFactory> callback) {
        AttachmentNbtFactory attachmentNbtFactory;
        if (item instanceof AttachmentItem) {
            AttachmentItem attachmentItem = (AttachmentItem)item;
            attachmentNbtFactory = new AttachmentNbtFactory(attachmentItem);
        } else {
            attachmentNbtFactory = new AttachmentNbtFactory();
        }
        AttachmentNbtFactory itemBuilder = attachmentNbtFactory;
        callback.accept(itemBuilder);
        return itemBuilder.build();
    }

    public static ItemStack ammoItem(Consumer<AmmoItemBuilder> callback) {
        AmmoItemBuilder itemBuilder = AmmoItemBuilder.create();
        callback.accept(itemBuilder);
        return itemBuilder.build();
    }

    public static ItemStack ammoItem(Item item, Consumer<AmmoNbtFactory> callback) {
        AmmoNbtFactory ammoNbtFactory;
        if (item instanceof AmmoItem) {
            AmmoItem ammoItem = (AmmoItem)item;
            ammoNbtFactory = new AmmoNbtFactory(ammoItem);
        } else {
            ammoNbtFactory = new AmmoNbtFactory();
        }
        AmmoNbtFactory itemBuilder = ammoNbtFactory;
        callback.accept(itemBuilder);
        return itemBuilder.build();
    }

    public static ItemStack blockItem(ItemLike itemLike, Consumer<BlockItemBuilder> callback) {
        BlockItemBuilder itemBuilder = BlockItemBuilder.create(itemLike);
        callback.accept(itemBuilder);
        return itemBuilder.build();
    }

    public static ItemStack of(ResourceLocation id) {
        return ItemIndexInfo.createFromResourceLocation(id).getItemStack();
    }

    public static ItemStack of(Item item, ResourceLocation id) {
        return ItemIndexInfo.createFromResourceLocation(id).getItemStack(item);
    }

    public static class ItemIndexInfo {
        private static final String FALL_BACK = "error";
        private final String parent;
        private final ResourceLocation indexId;
        private static final ItemIndexInfo DEFAULT = new ItemIndexInfo("error", DefaultAssets.EMPTY_GUN_ID);

        private ItemIndexInfo(String pNamespace, String pParent, String pPath) {
            this.parent = ItemIndexInfo.isTypeValid(pParent) ? pParent : FALL_BACK;
            this.indexId = new ResourceLocation(pNamespace, pPath);
        }

        private ItemIndexInfo(String pParent, ResourceLocation pLocation) {
            this.parent = ItemIndexInfo.isTypeValid(pParent) ? pParent : FALL_BACK;
            this.indexId = pLocation != null ? pLocation : DefaultAssets.EMPTY_GUN_ID;
        }

        public static ItemIndexInfo createFromResourceLocation(ResourceLocation id) {
            String namespace = id.m_135827_();
            String path = id.m_135815_();
            int i = path.indexOf("/");
            if (i > 0) {
                String type = path.substring(0, i);
                String indexPath = path.substring(i + 1);
                return new ItemIndexInfo(namespace, type, indexPath);
            }
            return DEFAULT;
        }

        public static ItemIndexInfo create(String pLocation) {
            ResourceLocation id = new ResourceLocation(pLocation);
            return ItemIndexInfo.createFromResourceLocation(id);
        }

        public String getParent() {
            return this.parent;
        }

        public ResourceLocation getIndexId() {
            return this.indexId;
        }

        public ItemStack getItemStack() {
            return switch (this.parent) {
                case "gun" -> TimelessItemWrapper.gunItem(builder -> builder.setId(this.indexId));
                case "attachment" -> TimelessItemWrapper.attachmentItem(builder -> builder.setId(this.indexId));
                case "ammo" -> TimelessItemWrapper.ammoItem(builder -> builder.setId(this.indexId));
                default -> ItemStack.f_41583_;
            };
        }

        public ItemStack getItemStack(Item item) {
            return switch (this.parent) {
                case "gun" -> TimelessItemWrapper.gunItem(item, builder -> builder.setId(this.indexId));
                case "attachment" -> TimelessItemWrapper.attachmentItem(item, builder -> builder.setId(this.indexId));
                case "ammo" -> TimelessItemWrapper.ammoItem(item, builder -> builder.setId(this.indexId));
                case "block" -> TimelessItemWrapper.blockItem((ItemLike)item, builder -> builder.setId(this.indexId));
                default -> ItemStack.f_41583_;
            };
        }

        public boolean isValid() {
            return ItemIndexInfo.isTypeValid(this.parent);
        }

        public boolean isValidForRecipe() {
            return ItemIndexInfo.isTypeValidForRecipe(this.parent);
        }

        private static boolean isTypeValid(String type) {
            return type != null && (type.equals("gun") || type.equals("attachment") || type.equals("ammo") || type.equals("block"));
        }

        private static boolean isTypeValidForRecipe(String type) {
            return type != null && (type.equals("gun") || type.equals("attachment") || type.equals("ammo"));
        }
    }
}

