/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tacz.guns.compat.kubejs.util.TimelessItemWrapper;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.UtilsJS;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;

public class GunSmithTableResultInfo {
    private static final String TYPE_KEY = "type";
    private static final String ID_KEY = "id";
    private static final String COUNT_KEY = "count";
    private static final String NBT_KEY = "nbt";
    private static final String CUSTOM_ITEM_KEY = "item";
    private static final String OUTPUT_GROUP_KEY = "group";
    private final JsonObject json;

    private GunSmithTableResultInfo() {
        this(new JsonObject());
    }

    private GunSmithTableResultInfo(JsonObject jsonObject) {
        this.json = jsonObject != null ? jsonObject : new JsonObject();
    }

    public static GunSmithTableResultInfo create() {
        return new GunSmithTableResultInfo();
    }

    public static GunSmithTableResultInfo createFromJson(JsonObject jsonObject) {
        return new GunSmithTableResultInfo(jsonObject);
    }

    public static GunSmithTableResultInfo createFromItemStack(ItemStack stack) {
        GunSmithTableResultInfo info = GunSmithTableResultInfo.create().setType("custom");
        JsonObject itemJson = new JsonObject();
        itemJson.addProperty(CUSTOM_ITEM_KEY, RegistryInfo.ITEM.getId((Object)stack.m_41720_()).toString());
        itemJson.addProperty(COUNT_KEY, (Number)stack.m_41613_());
        if (JsonIO.of((Object)stack.m_41783_()) != null) {
            itemJson.addProperty(NBT_KEY, stack.m_41784_().toString());
        }
        info.setCustomItem(itemJson);
        return info;
    }

    public static GunSmithTableResultInfo of(Object object) {
        ResourceLocation rl;
        TimelessItemWrapper.ItemIndexInfo indexInfo;
        if (object instanceof GunSmithTableResultInfo) {
            GunSmithTableResultInfo info = (GunSmithTableResultInfo)object;
            return info;
        }
        if (object instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)object;
            return GunSmithTableResultInfo.createFromJson(jsonObject);
        }
        if (object instanceof OutputItem) {
            OutputItem outputItem = (OutputItem)object;
            return GunSmithTableResultInfo.createFromItemStack(outputItem.item);
        }
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return GunSmithTableResultInfo.createFromItemStack(stack);
        }
        String idString = object.toString();
        if (ResourceLocation.m_135830_((String)idString) && (indexInfo = TimelessItemWrapper.ItemIndexInfo.createFromResourceLocation(rl = UtilsJS.getMCID(null, (Object)idString))).isValidForRecipe()) {
            return GunSmithTableResultInfo.create().setType(indexInfo.getParent()).setId(indexInfo.getIndexId());
        }
        ItemStack stack = ItemStackJS.of((Object)object);
        if (!stack.m_41619_()) {
            return GunSmithTableResultInfo.createFromItemStack(stack);
        }
        return GunSmithTableResultInfo.createFromJson(JsonIO.of((Object)object).getAsJsonObject());
    }

    public String getType() {
        return GsonHelper.m_13906_((JsonObject)this.json, (String)TYPE_KEY);
    }

    public GunSmithTableResultInfo setType(String typeName) {
        this.json.addProperty(TYPE_KEY, typeName);
        return this;
    }

    public ResourceLocation getId() {
        return ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)this.json, (String)ID_KEY));
    }

    public GunSmithTableResultInfo setId(ResourceLocation id) {
        this.json.addProperty(ID_KEY, id.toString());
        return this;
    }

    public CompoundTag getNbt() {
        return CraftingHelper.getNBT((JsonElement)this.json.get(NBT_KEY));
    }

    public GunSmithTableResultInfo setNbt(CompoundTag nbt) {
        this.json.addProperty(NBT_KEY, nbt.toString());
        return this;
    }

    public int getCount() {
        return Math.max(GsonHelper.m_13927_((JsonObject)this.json, (String)COUNT_KEY), 1);
    }

    public GunSmithTableResultInfo setCount(int count) {
        this.json.addProperty(COUNT_KEY, (Number)count);
        return this;
    }

    public JsonObject getCustomItem() {
        return GsonHelper.m_13930_((JsonObject)this.json, (String)CUSTOM_ITEM_KEY);
    }

    public GunSmithTableResultInfo setCustomItem(JsonObject itemJson) {
        this.json.add(CUSTOM_ITEM_KEY, (JsonElement)itemJson);
        return this;
    }

    public GunSmithTableResultInfo setGroupName(String groupName) {
        this.json.addProperty(OUTPUT_GROUP_KEY, groupName);
        return this;
    }

    public GunSmithTableResultInfo setGroup(OutputGroupName group) {
        this.setGroupName(group.getName());
        return this;
    }

    public JsonObject toJson() {
        return this.json;
    }

    public static enum OutputGroupName {
        AMMO("ammo"),
        EXTENDED_MAG("extended_mag"),
        GRIP("grip"),
        MG("mg"),
        MUZZLE("muzzle"),
        PISTOL("pistol"),
        RIFLE("rifle"),
        RPG("rpg"),
        SCOPE("scope"),
        SHOTGUN("shotgun"),
        SMG("smg"),
        SNIPER("sniper"),
        STOCK("stock");

        private final String name;

        private OutputGroupName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

