/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerBoltGun;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LocalPlayerBolt {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerBolt(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void bolt() {
        if (this.data.clientStateLock) {
            return;
        }
        if (this.data.isBolting) {
            return;
        }
        ItemStack mainHandItem = this.player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        GunData gunData = TimelessAPI.getClientGunIndex(iGun.getGunId(mainHandItem)).map(ClientGunIndex::getGunData).orElse(null);
        if (gunData == null) {
            return;
        }
        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(display -> {
            boolean noAmmo;
            IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)this.player);
            Bolt boltType = gunData.getBolt();
            boolean useInventoryAmmo = iGun.useInventoryAmmo(mainHandItem);
            boolean hasAmmoInBarrel = iGun.hasBulletInBarrel(mainHandItem) && boltType != Bolt.OPEN_BOLT;
            boolean hasInventoryAmmo = iGun.hasInventoryAmmo((LivingEntity)this.player, mainHandItem, gunOperator.needCheckAmmo());
            boolean bl = noAmmo = useInventoryAmmo && !hasInventoryAmmo || !useInventoryAmmo && iGun.getCurrentAmmoCount(mainHandItem) < 1;
            if (boltType != Bolt.MANUAL_ACTION) {
                return;
            }
            if (hasAmmoInBarrel) {
                return;
            }
            if (noAmmo) {
                return;
            }
            this.data.lockState(IGunOperator::getSynIsBolting);
            this.data.isBolting = true;
            NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerBoltGun());
            LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
            if (animationStateMachine != null) {
                SoundPlayManager.playBoltSound((LivingEntity)this.player, display);
                animationStateMachine.trigger("blot");
            }
        });
    }

    public void tickAutoBolt() {
        ItemStack mainHandItem = this.player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (!(item instanceof IGun)) {
            this.data.isBolting = false;
            return;
        }
        IGun iGun = (IGun)item;
        this.bolt();
        if (this.data.isBolting && iGun.hasBulletInBarrel(mainHandItem)) {
            this.data.isBolting = false;
        }
    }
}

