/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.other;

import com.google.common.collect.Maps;
import com.tacz.guns.api.client.other.IThirdPersonAnimation;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public final class ThirdPersonManager {
    private static final Map<String, IThirdPersonAnimation> CACHE = Maps.newHashMap();
    private static final String RESERVED_DEFAULT_NAME = "default";
    private static final IThirdPersonAnimation DEFAULT = new IThirdPersonAnimation(){

        @Override
        public void animateGunHold(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head) {
            rightArm.f_104204_ = -0.3f + head.f_104204_;
            leftArm.f_104204_ = 0.8f + head.f_104204_;
            rightArm.f_104203_ = -1.4f + head.f_104203_;
            leftArm.f_104203_ = -1.4f + head.f_104203_;
        }

        @Override
        public void animateGunAim(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head, float aimProgress) {
            float lerp1 = Mth.m_14179_((float)aimProgress, (float)0.3f, (float)0.35f);
            float lerp2 = Mth.m_14179_((float)aimProgress, (float)1.4f, (float)1.6f);
            rightArm.f_104204_ = -lerp1 + head.f_104204_;
            leftArm.f_104204_ = 0.8f + head.f_104204_;
            rightArm.f_104203_ = -lerp2 + head.f_104203_;
            leftArm.f_104203_ = -lerp2 + head.f_104203_;
        }
    };
    private static final String MINI_GUN_NAME = "minigun";
    private static final IThirdPersonAnimation MINI_GUN = new IThirdPersonAnimation(){

        @Override
        public void animateGunHold(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head) {
            body.f_104204_ = head.f_104204_ + 0.8f;
            double cosTheta = Math.cos(-body.f_104204_);
            double sinTheta = Math.sin(-body.f_104204_);
            float x = rightArm.f_104200_;
            rightArm.f_104200_ = (float)((double)x * cosTheta);
            rightArm.f_104202_ = (float)((double)x * sinTheta);
            rightArm.f_104204_ = -1.0f + body.f_104204_;
            rightArm.f_104203_ = -0.1f + body.f_104203_;
            float x2 = leftArm.f_104200_;
            leftArm.f_104200_ = (float)((double)x2 * cosTheta);
            leftArm.f_104202_ = (float)((double)x2 * sinTheta);
            leftArm.f_104204_ = -0.1f + body.f_104204_;
            leftArm.f_104203_ = -1.0f + body.f_104203_;
        }

        @Override
        public void animateGunAim(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head, float aimProgress) {
            this.animateGunHold(entity, rightArm, leftArm, body, head);
        }
    };

    public static void registerDefault() {
        CACHE.put(RESERVED_DEFAULT_NAME, DEFAULT);
        CACHE.put(MINI_GUN_NAME, MINI_GUN);
    }

    public static void register(String name, IThirdPersonAnimation animation) {
        if (name.equals(RESERVED_DEFAULT_NAME)) {
            return;
        }
        CACHE.put(name, animation);
    }

    public static IThirdPersonAnimation getAnimation(String name) {
        return CACHE.getOrDefault(name, DEFAULT);
    }
}

