/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.animation;

import com.tacz.guns.api.client.animation.AnimationListener;
import com.tacz.guns.api.client.animation.AnimationListenerSupplier;
import com.tacz.guns.api.client.animation.ObjectAnimationChannel;
import com.tacz.guns.api.client.animation.ObjectAnimationSoundChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ObjectAnimation {
    public final String name;
    private final Map<String, List<ObjectAnimationChannel>> channels = new HashMap<String, List<ObjectAnimationChannel>>();
    @Nullable
    private ObjectAnimationSoundChannel soundChannel;
    @Nonnull
    public PlayType playType = PlayType.PLAY_ONCE_HOLD;
    private float maxEndTimeS = 0.0f;

    protected ObjectAnimation(@Nonnull String name) {
        this.name = Objects.requireNonNull(name);
    }

    public ObjectAnimation(ObjectAnimation source) {
        this.name = source.name;
        this.playType = source.playType;
        this.maxEndTimeS = source.maxEndTimeS;
        for (Map.Entry<String, List<ObjectAnimationChannel>> entry : source.channels.entrySet()) {
            ArrayList<ObjectAnimationChannel> newList = new ArrayList<ObjectAnimationChannel>();
            for (ObjectAnimationChannel channel : entry.getValue()) {
                ObjectAnimationChannel newChannel = new ObjectAnimationChannel(channel.type, channel.content);
                newChannel.node = channel.node;
                newChannel.interpolator = channel.interpolator;
                newList.add(newChannel);
            }
            this.channels.put(entry.getKey(), newList);
        }
        if (source.soundChannel != null) {
            this.soundChannel = new ObjectAnimationSoundChannel(source.soundChannel.content);
        }
    }

    protected void addChannel(ObjectAnimationChannel channel) {
        this.channels.compute(channel.node, (node, list) -> {
            if (list == null) {
                list = new ArrayList<ObjectAnimationChannel>();
            }
            list.add(channel);
            return list;
        });
        if (channel.getEndTimeS() > this.maxEndTimeS) {
            this.maxEndTimeS = channel.getEndTimeS();
        }
    }

    protected void setSoundChannel(@Nonnull ObjectAnimationSoundChannel soundChannel) {
        if (soundChannel.getEndTimeS() > (double)this.maxEndTimeS) {
            this.maxEndTimeS = (float)soundChannel.getEndTimeS();
        }
        this.soundChannel = soundChannel;
    }

    public Map<String, List<ObjectAnimationChannel>> getChannels() {
        return this.channels;
    }

    @Nullable
    public ObjectAnimationSoundChannel getSoundChannel() {
        return this.soundChannel;
    }

    public void applyAnimationListeners(AnimationListenerSupplier supplier) {
        for (List<ObjectAnimationChannel> channelList : this.channels.values()) {
            for (ObjectAnimationChannel channel : channelList) {
                AnimationListener listener = supplier.supplyListeners(channel.node, channel.type);
                if (listener == null) continue;
                channel.addListener(listener);
            }
        }
    }

    public void update(boolean blend, float timeNs) {
        for (List<ObjectAnimationChannel> channels : this.channels.values()) {
            for (ObjectAnimationChannel channel : channels) {
                channel.update(timeNs / 1.0E9f, blend);
            }
        }
    }

    public float getMaxEndTimeS() {
        return this.maxEndTimeS;
    }

    public static enum PlayType {
        PLAY_ONCE_HOLD,
        PLAY_ONCE_STOP,
        LOOP;

    }
}

