/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import immersive_armors.armor_effects.ArmorEffect;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WitherArmorEffect
extends ArmorEffect {
    private final float immunity;
    private final int wither;

    public WitherArmorEffect(float immunity, int wither) {
        this.immunity = immunity;
        this.wither = wither;
    }

    @Override
    public void appendTooltip(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.appendTooltip(stack, world, tooltip, context);
        tooltip.add((Component)Component.m_237110_((String)"armorEffect.wither", (Object[])new Object[]{this.wither}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        LivingEntity attacker;
        Entity entity2;
        if (this.isPrimaryArmor(armor, entity) && (entity2 = source.m_7639_()) instanceof LivingEntity && !(attacker = (LivingEntity)entity2).m_5825_()) {
            attacker.m_7292_(new MobEffectInstance(MobEffects.f_19615_, this.wither * this.getSetCount(armor, entity)));
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return amount * (1.0f - this.immunity);
        }
        return amount;
    }
}

