/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.jei;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.crafting.WorkbenchRecipe;
import com.mrcrayfish.guns.init.ModBlocks;
import com.mrcrayfish.guns.item.IColored;
import com.mrcrayfish.guns.jei.GunModPlugin;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class WorkbenchCategory
implements IRecipeCategory<WorkbenchRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("cgm", "workbench");
    public static final ResourceLocation BACKGROUND = new ResourceLocation("cgm", "textures/gui/workbench.png");
    public static final String TITLE_KEY = "cgm.category.workbench.title";
    public static final String MATERIALS_KEY = "cgm.category.workbench.materials";
    private final IDrawableStatic background;
    private final IDrawableStatic window;
    private final IDrawableStatic inventory;
    private final IDrawableStatic dyeSlot;
    private final IDrawable icon;
    private final Component title;
    private final Item[] dyes;

    public WorkbenchCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(162, 124);
        this.window = helper.createDrawable(BACKGROUND, 7, 15, 162, 72);
        this.inventory = helper.createDrawable(BACKGROUND, 7, 101, 162, 36);
        this.dyeSlot = helper.createDrawable(BACKGROUND, 7, 101, 18, 18);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.WORKBENCH.get()));
        this.title = Component.m_237115_((String)TITLE_KEY);
        this.dyes = (Item[])ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof DyeItem).toArray(Item[]::new);
    }

    public RecipeType<WorkbenchRecipe> getRecipeType() {
        return GunModPlugin.WORKBENCH;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WorkbenchRecipe recipe, IFocusGroup focuses) {
        ItemStack output = recipe.getItem();
        if (IColored.isDyeable(output)) {
            builder.addSlot(RecipeIngredientRole.INPUT, 141, 52).addItemStacks(Stream.of(this.dyes).map(ItemStack::new).collect(Collectors.toList()));
        }
        for (int i = 0; i < recipe.getMaterials().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, i % 8 * 18 + 1, 88 + i / 8 * 18).addIngredients((Ingredient)recipe.getMaterials().get(i));
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(output);
    }

    public void draw(WorkbenchRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        this.window.draw(poseStack, 0, 0);
        this.inventory.draw(poseStack, 0, this.window.getHeight() + 2 + 11 + 2);
        this.dyeSlot.draw(poseStack, 140, 51);
        Minecraft.m_91087_().f_91062_.m_92883_(poseStack, I18n.m_118938_((String)MATERIALS_KEY, (Object[])new Object[0]), 0.0f, 78.0f, 0x7E7E7E);
        ItemStack output = recipe.getItem();
        MutableComponent displayName = output.m_41786_().m_6881_();
        if (output.m_41613_() > 1) {
            displayName.m_7220_((Component)Component.m_237113_((String)(" x " + output.m_41613_())).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        }
        int titleX = this.window.getWidth() / 2;
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)displayName, (int)titleX, (int)5, (int)-1);
        PoseStack stack = RenderSystem.m_157191_();
        stack.m_85836_();
        stack.m_252931_(poseStack.m_85850_().m_252922_());
        stack.m_252880_(81.0f, 40.0f, 0.0f);
        stack.m_85841_(40.0f, 40.0f, 40.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(-5.0f));
        float partialTicks = Minecraft.m_91087_().m_91296_();
        stack.m_252781_(Axis.f_252436_.m_252977_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
        stack.m_85841_(-1.0f, -1.0f, -1.0f);
        RenderSystem.m_157182_();
        BakedModel model = RenderUtil.getModel(output);
        Lighting.m_84931_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Minecraft.m_91087_().m_91291_().m_115143_(output, ItemDisplayContext.FIXED, false, new PoseStack(), (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        stack.m_85849_();
        RenderSystem.m_157182_();
    }
}

