/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.init.ModBiomes;
import biomesoplenty.init.ModBlocks;
import biomesoplenty.init.ModConfig;
import biomesoplenty.init.ModEntities;
import biomesoplenty.init.ModFeatures;
import biomesoplenty.init.ModFluids;
import biomesoplenty.init.ModItems;
import biomesoplenty.init.ModPaintings;
import biomesoplenty.init.ModParticles;
import biomesoplenty.init.ModSounds;
import biomesoplenty.init.ModTags;
import biomesoplenty.init.ModVanillaCompat;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="biomesoplenty")
public class BiomesOPlenty {
    public static final String MOD_ID = "biomesoplenty";
    public static final DeferredRegister<Biome> BIOME_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256952_, (String)"biomesoplenty");
    public static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"biomesoplenty");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"biomesoplenty");
    public static final DeferredRegister<WorldCarver<?>> CARVER_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256812_, (String)"biomesoplenty");
    public static final DeferredRegister<ConfiguredWorldCarver<?>> CONFIGURED_CARVER_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_257003_, (String)"biomesoplenty");
    public static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256911_, (String)"biomesoplenty");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256939_, (String)"biomesoplenty");
    public static final DeferredRegister<Feature<?>> FEATURE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256833_, (String)"biomesoplenty");
    public static final DeferredRegister<Fluid> FLUID_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256808_, (String)"biomesoplenty");
    public static final DeferredRegister<FluidType> FORGE_FLUID_REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"biomesoplenty");
    public static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"biomesoplenty");
    public static final DeferredRegister<ParticleType<?>> PARTICLES_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"biomesoplenty");
    public static final DeferredRegister<PaintingVariant> PAINTING_VARIANT_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256836_, (String)"biomesoplenty");
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256988_, (String)"biomesoplenty");
    public static final DeferredRegister<SoundEvent> SOUND_EVENT_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256840_, (String)"biomesoplenty");
    public static final DeferredRegister<DamageType> DAMAGE_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_268580_, (String)"biomesoplenty");
    public static BiomesOPlenty instance;
    public static final Logger LOGGER;

    public BiomesOPlenty() {
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::loadComplete);
        bus.addListener(this::registerTab);
        BIOME_REGISTER.register(bus);
        BLOCK_REGISTER.register(bus);
        BLOCK_ENTITY_REGISTER.register(bus);
        CARVER_REGISTER.register(bus);
        CONFIGURED_CARVER_REGISTER.register(bus);
        CONFIGURED_FEATURE_REGISTER.register(bus);
        ENTITY_TYPE_REGISTER.register(bus);
        FEATURE_REGISTER.register(bus);
        FLUID_REGISTER.register(bus);
        FORGE_FLUID_REGISTER.register(bus);
        ITEM_REGISTER.register(bus);
        PARTICLES_REGISTER.register(bus);
        PLACED_FEATURE_REGISTER.register(bus);
        SOUND_EVENT_REGISTER.register(bus);
        DAMAGE_TYPE_REGISTER.register(bus);
        ModConfig.setup();
        ModBlocks.setup();
        ModItems.setup();
        ModFluids.setup();
        ModEntities.setup();
        ModFeatures.setup();
        ModBiomes.setup();
        ModParticles.setup();
        ModPaintings.setup();
        ModSounds.setup();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModBiomes.setupTerraBlender();
            ModVanillaCompat.setup();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ModBlocks::registerWoodTypes);
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        ModTags.setup();
    }

    private void registerTab(CreativeModeTabEvent.Register event) {
        List<RegistryObject<Item>> itemBlacklist = List.of(BOPItems.BOP_ICON);
        List<RegistryObject> blockBlacklist = List.of(BOPBlocks.BLOOD, BOPBlocks.SPANISH_MOSS_PLANT, BOPBlocks.GLOWWORM_SILK_STRAND, BOPBlocks.HANGING_COBWEB_STRAND, BOPBlocks.FLESH_TENDONS_STRAND, BOPBlocks.POTTED_ORIGIN_SAPLING, BOPBlocks.POTTED_FLOWERING_OAK_SAPLING, BOPBlocks.POTTED_RAINBOW_BIRCH_SAPLING, BOPBlocks.POTTED_YELLOW_AUTUMN_SAPLING, BOPBlocks.POTTED_ORANGE_AUTUMN_SAPLING, BOPBlocks.POTTED_MAPLE_SAPLING, BOPBlocks.POTTED_FIR_SAPLING, BOPBlocks.POTTED_REDWOOD_SAPLING, BOPBlocks.POTTED_WHITE_CHERRY_SAPLING, BOPBlocks.POTTED_PINK_CHERRY_SAPLING, BOPBlocks.POTTED_MAHOGANY_SAPLING, BOPBlocks.POTTED_JACARANDA_SAPLING, BOPBlocks.POTTED_PALM_SAPLING, BOPBlocks.POTTED_WILLOW_SAPLING, BOPBlocks.POTTED_DEAD_SAPLING, BOPBlocks.POTTED_MAGIC_SAPLING, BOPBlocks.POTTED_UMBRAN_SAPLING, BOPBlocks.POTTED_HELLBARK_SAPLING, BOPBlocks.POTTED_ROSE, BOPBlocks.POTTED_VIOLET, BOPBlocks.POTTED_LAVENDER, BOPBlocks.POTTED_WILDFLOWER, BOPBlocks.POTTED_ORANGE_COSMOS, BOPBlocks.POTTED_PINK_DAFFODIL, BOPBlocks.POTTED_PINK_HIBISCUS, BOPBlocks.POTTED_GLOWFLOWER, BOPBlocks.POTTED_WILTED_LILY, BOPBlocks.POTTED_BURNING_BLOSSOM, BOPBlocks.POTTED_SPROUT, BOPBlocks.POTTED_CLOVER, BOPBlocks.POTTED_TOADSTOOL, BOPBlocks.POTTED_GLOWSHROOM);
        event.registerCreativeModeTab(new ResourceLocation(MOD_ID, "main"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)BOPItems.BOP_ICON.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.biomesoplenty")).m_257501_((displayParameters, output) -> {
            for (Field field : BOPBlocks.class.getFields()) {
                if (field.getType() != RegistryObject.class) continue;
                try {
                    RegistryObject block = (RegistryObject)field.get(null);
                    if (blockBlacklist.contains(block)) continue;
                    output.m_246342_(new ItemStack((ItemLike)block.get()));
                }
                catch (IllegalAccessException block) {
                    // empty catch block
                }
            }
            for (Field field : BOPItems.class.getFields()) {
                if (field.getType() != RegistryObject.class) continue;
                try {
                    RegistryObject item = (RegistryObject)field.get(null);
                    if (itemBlacklist.contains(item)) continue;
                    output.m_246342_(new ItemStack((ItemLike)item.get()));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }));
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
    }
}

