/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.worldgen.feature.configurations.PoplarTreeConfiguration;
import biomesoplenty.common.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.material.Material;

public class PoplarTreeFeature
extends BOPTreeFeature<PoplarTreeConfiguration> {
    public PoplarTreeFeature(Codec<PoplarTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        int i;
        PoplarTreeConfiguration config = (PoplarTreeConfiguration)configBase;
        while (startPos.m_123342_() > 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        if (height < 4) {
            return false;
        }
        int baseHeight = height / 3;
        int leavesHeight = height - baseHeight;
        BlockPos pos = startPos.m_7494_();
        if (!this.checkSpace((LevelAccessor)world, pos, baseHeight, height)) {
            return false;
        }
        for (i = 0; i < baseHeight; ++i) {
            this.placeLog((LevelAccessor)world, pos, logs, config);
            pos = pos.m_7494_();
        }
        for (i = 1; i < leavesHeight - 3; ++i) {
            for (int xx = -1; xx < 2; ++xx) {
                for (int zz = -1; zz < 2; ++zz) {
                    this.placeLeaves((LevelAccessor)world, pos.m_7918_(xx, i, zz), leaves, config);
                }
            }
        }
        for (i = 0; i < leavesHeight; ++i) {
            int radius = this.radius(i, leavesHeight);
            this.generateLeafLayer((LevelAccessor)world, pos, radius, leaves, config);
            if (leavesHeight - i > 2) {
                this.placeLog((LevelAccessor)world, pos, logs, config);
            }
            pos = pos.m_7494_();
        }
        return true;
    }

    public int radius(int height, int maxHeight) {
        float x = (float)height / (float)maxHeight;
        float maxRadius = 1.0f + (float)maxHeight * 0.1f;
        float r = maxRadius * 0.6667f * x * (1.0f / (x * x + 0.08173f) - 0.9244f);
        return (int)(r + 0.5f);
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int radius = y <= baseHeight ? 0 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeafLayer(LevelAccessor world, BlockPos pos, int radius, FoliagePlacer.FoliageSetter leaves, PoplarTreeConfiguration config) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (radius < 2) {
                    if (x * x + z * z > radius * radius) continue;
                    this.placeLeaves(world, pos.m_7918_(x, 0, z), leaves, config);
                    continue;
                }
                if ((x == -radius || x == radius) && (z == -radius || z == radius)) continue;
                if (x == -radius || x == radius || z == -radius || z == radius) {
                    if (world.m_213780_().m_188503_(3) == 0) continue;
                    this.placeLeaves(world, pos.m_7918_(x, 0, z), leaves, config);
                    continue;
                }
                this.placeLeaves(world, pos.m_7918_(x, 0, z), leaves, config);
            }
        }
    }
}

