/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.worldgen.feature.configurations.PalmTreeConfiguration;
import biomesoplenty.common.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.material.Material;

public class PalmTreeFeature
extends BOPTreeFeature<PalmTreeConfiguration> {
    public PalmTreeFeature(Codec<PalmTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        PalmTreeConfiguration config = (PalmTreeConfiguration)configBase;
        while (startPos.m_123342_() > 1 && world.m_46859_(startPos) || world.m_8055_(startPos).m_60767_() == Material.f_76274_) {
            startPos = startPos.m_7495_();
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        int leavesRadius = 2;
        int heightMinusTop = height - leavesRadius - 1;
        boolean slant = true;
        Direction direction = Direction.m_235672_((RandomSource)random);
        if (direction == Direction.DOWN || direction == Direction.UP) {
            slant = false;
        }
        double baseSlant = (double)random.m_188503_(35) / 100.0;
        double slantMultiplier = 1.3;
        if (height < 8) {
            return false;
        }
        BlockPos pos = startPos.m_7494_();
        if (!this.checkSpace((LevelAccessor)world, pos, height, 1)) {
            return false;
        }
        double slantOffset = baseSlant;
        for (int step = 0; step <= heightMinusTop; ++step) {
            BlockPos offsetPos = pos.m_6630_(step);
            if (slant) {
                offsetPos = pos.m_6630_(step).m_5484_(direction, (int)Math.floor(slantOffset));
            }
            if (step == heightMinusTop) {
                this.placeLog((LevelAccessor)world, offsetPos, logs, config);
                this.generateLeavesTop((LevelAccessor)world, offsetPos, leavesRadius, leaves, config);
                break;
            }
            this.placeLog((LevelAccessor)world, offsetPos, logs, config);
            slantOffset *= slantMultiplier;
        }
        return true;
    }

    public boolean checkSpace(LevelAccessor world, BlockPos pos, int height, int radius) {
        for (int y = 0; y <= height; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.canReplace(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateLeavesTop(LevelAccessor world, BlockPos pos, int maxRadius, FoliagePlacer.FoliageSetter leaves, PalmTreeConfiguration config) {
        this.placeLeaves(world, pos.m_7918_(2, -1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, -1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, -1, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, -1, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 0, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 0, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 0, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 0, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 0, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 0, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 0, -2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 0, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 1, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(2, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(-2, 2, 0), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, 2), leaves, config);
        this.placeLeaves(world, pos.m_7918_(0, 2, -2), leaves, config);
    }
}

