/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.tree;

import biomesoplenty.common.worldgen.feature.configurations.BigTreeConfiguration;
import biomesoplenty.common.worldgen.feature.tree.BOPTreeFeature;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class BigTreeFeature
extends BOPTreeFeature<BigTreeConfiguration> {
    private final double trunkHeightScale = 0.618;
    private final double branchSlope = 0.381;
    private final double widthScale = 1.0;
    private final int trunkWidth = 1;

    public BigTreeFeature(Codec<BigTreeConfiguration> codec) {
        super(codec);
    }

    private void crossSection(LevelAccessor world, BlockPos pos, float radius, RandomSource random, FoliagePlacer.FoliageSetter leaves, BigTreeConfiguration config) {
        int r = (int)((double)radius + 0.618);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                BlockPos blockpos;
                if (!(Math.pow((double)Math.abs(dx) + 0.5, 2.0) + Math.pow((double)Math.abs(dz) + 0.5, 2.0) <= (double)(radius * radius)) || !this.canReplace(world, blockpos = pos.m_7918_(dx, 0, dz))) continue;
                if (config.altFoliageProvider.m_213972_(random, pos) != Blocks.f_50016_.m_49966_()) {
                    int rand = random.m_188503_(4);
                    if (rand == 0) {
                        this.placeAltLeaves(world, blockpos, leaves, config);
                        continue;
                    }
                    this.placeLeaves(world, blockpos, leaves, config);
                    continue;
                }
                this.placeLeaves(world, blockpos, leaves, config);
            }
        }
    }

    private float treeShape(int height, int y) {
        if ((float)y < (float)height * 0.3f) {
            return -1.0f;
        }
        float radius = (float)height / 2.0f;
        float adjacent = radius - (float)y;
        float distance = Mth.m_14116_((float)(radius * radius - adjacent * adjacent));
        if (adjacent == 0.0f) {
            distance = radius;
        } else if (Math.abs(adjacent) >= radius) {
            return 0.0f;
        }
        return distance * 0.5f;
    }

    private float foliageShape(int y, BigTreeConfiguration config) {
        if (y < 0 || y >= config.foliageHeight) {
            return -1.0f;
        }
        if (y == 0 || y == config.foliageHeight - 1) {
            return 2.0f;
        }
        return 3.0f;
    }

    private void foliageCluster(LevelAccessor world, BlockPos pos, RandomSource random, FoliagePlacer.FoliageSetter leaves, BigTreeConfiguration config) {
        for (int y = 0; y < config.foliageHeight; ++y) {
            this.crossSection(world, pos.m_6630_(y), this.foliageShape(y, config), random, leaves, config);
        }
    }

    private int checkLineAndOptionallySet(LevelAccessor world, BlockPos startPos, BlockPos endPos, boolean set, BiConsumer<BlockPos, BlockState> logs, BigTreeConfiguration config) {
        if (!set && Objects.equals(startPos, endPos)) {
            return -1;
        }
        BlockPos delta = endPos.m_7918_(-startPos.m_123341_(), -startPos.m_123342_(), -startPos.m_123343_());
        int steps = this.getGreatestDistance(delta);
        float dx = (float)delta.m_123341_() / (float)steps;
        float dy = (float)delta.m_123342_() / (float)steps;
        float dz = (float)delta.m_123343_() / (float)steps;
        for (int j = 0; j <= steps; ++j) {
            BlockPos deltaPos = startPos.m_7918_(Mth.m_14107_((double)(0.5f + (float)j * dx)), Mth.m_14107_((double)(0.5f + (float)j * dy)), Mth.m_14107_((double)(0.5f + (float)j * dz)));
            if (set) {
                this.placeLog(world, deltaPos, this.getLogAxis(startPos, deltaPos), logs, config);
                continue;
            }
            if (BigTreeFeature.isFree((LevelSimulatedReader)world, deltaPos)) continue;
            return j;
        }
        return -1;
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = Mth.m_14040_((int)posIn.m_123341_());
        int j = Mth.m_14040_((int)posIn.m_123342_());
        int k = Mth.m_14040_((int)posIn.m_123343_());
        return k > i && k > j ? k : (j > i ? j : i);
    }

    private Direction.Axis getLogAxis(BlockPos startPos, BlockPos endPos) {
        int zDiff;
        Direction.Axis axis = Direction.Axis.Y;
        int xDiff = Math.abs(endPos.m_123341_() - startPos.m_123341_());
        int maxDiff = Math.max(xDiff, zDiff = Math.abs(endPos.m_123343_() - startPos.m_123343_()));
        if (maxDiff > 0) {
            if (xDiff == maxDiff) {
                axis = Direction.Axis.X;
            } else if (zDiff == maxDiff) {
                axis = Direction.Axis.Z;
            }
        }
        return axis;
    }

    private void makeFoliage(LevelAccessor worldIn, int height, BlockPos pos, List<FoliageCoordinates> coordinates, RandomSource random, FoliagePlacer.FoliageSetter leaves, BigTreeConfiguration config) {
        for (FoliageCoordinates coordinate : coordinates) {
            if (!this.trimBranches(height, coordinate.getBranchBase() - pos.m_123342_())) continue;
            this.foliageCluster(worldIn, coordinate, random, leaves, config);
        }
    }

    private boolean trimBranches(int height, int localY) {
        return (double)localY >= (double)height * 0.2;
    }

    private void makeTrunk(LevelAccessor world, BlockPos pos, int height, BiConsumer<BlockPos, BlockState> logs, BigTreeConfiguration config) {
        this.checkLineAndOptionallySet(world, pos, pos.m_6630_(height), true, logs, config);
    }

    private void makeBranches(LevelAccessor world, int height, BlockPos origin, List<FoliageCoordinates> coordinates, BiConsumer<BlockPos, BlockState> logs, BigTreeConfiguration config) {
        for (FoliageCoordinates coordinate : coordinates) {
            int branchBase = coordinate.getBranchBase();
            BlockPos baseCoord = new BlockPos(origin.m_123341_(), branchBase, origin.m_123343_());
            if (baseCoord.equals((Object)coordinate) || !this.trimBranches(height, branchBase - origin.m_123342_())) continue;
            this.checkLineAndOptionallySet(world, baseCoord, coordinate, true, logs, config);
        }
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        int relativeY;
        int clustersPerY;
        BigTreeConfiguration config = (BigTreeConfiguration)configBase;
        int height = this.checkLocation((LevelAccessor)world, pos, config.minHeight + random.m_188503_(config.maxHeight), logs, config);
        if (height == -1) {
            return false;
        }
        this.m_5974_((LevelWriter)world, pos.m_7495_(), Blocks.f_50493_.m_49966_());
        int trunkHeight = (int)((double)height * this.trunkHeightScale);
        if (trunkHeight >= height) {
            trunkHeight = height - 1;
        }
        if ((clustersPerY = (int)(1.382 + Math.pow(config.foliageDensity * (double)height / 13.0, 2.0))) < 1) {
            clustersPerY = 1;
        }
        int trunkTop = pos.m_123342_() + trunkHeight;
        ArrayList foliageCoords = Lists.newArrayList();
        foliageCoords.add(new FoliageCoordinates(pos.m_6630_(relativeY), trunkTop));
        for (relativeY = height - config.foliageHeight; relativeY >= 0; --relativeY) {
            float treeShape = this.treeShape(height, relativeY);
            if (treeShape < 0.0f) continue;
            for (int i = 0; i < clustersPerY; ++i) {
                BlockPos checkEnd;
                int z;
                double angle;
                double radius = 1.0 * (double)treeShape * ((double)random.m_188501_() + 0.328);
                int x = Mth.m_14107_((double)(radius * Math.sin(angle = (double)(random.m_188501_() * 2.0f) * Math.PI) + 0.5));
                BlockPos checkStart = pos.m_7918_(x, relativeY - 1, z = Mth.m_14107_((double)(radius * Math.cos(angle) + 0.5)));
                if (this.checkLineAndOptionallySet((LevelAccessor)world, checkStart, checkEnd = checkStart.m_6630_(5), false, logs, config) != -1) continue;
                int dx = pos.m_123341_() - checkStart.m_123341_();
                int dz = pos.m_123343_() - checkStart.m_123343_();
                double branchHeight = (double)checkStart.m_123342_() - Math.sqrt(dx * dx + dz * dz) * this.branchSlope;
                int branchTop = branchHeight > (double)trunkTop ? trunkTop : (int)branchHeight;
                BlockPos checkBranchBase = new BlockPos(pos.m_123341_(), branchTop, pos.m_123343_());
                if (this.checkLineAndOptionallySet((LevelAccessor)world, checkBranchBase, checkStart, false, logs, config) != -1) continue;
                foliageCoords.add(new FoliageCoordinates(checkStart, checkBranchBase.m_123342_()));
            }
        }
        this.makeFoliage((LevelAccessor)world, height, pos, foliageCoords, random, leaves, config);
        this.makeTrunk((LevelAccessor)world, pos, trunkHeight, logs, config);
        this.makeBranches((LevelAccessor)world, height, pos, foliageCoords, logs, config);
        return true;
    }

    private int checkLocation(LevelAccessor world, BlockPos pos, int height, BiConsumer<BlockPos, BlockState> logs, BigTreeConfiguration config) {
        int step = this.checkLineAndOptionallySet(world, pos, pos.m_6630_(height - 1), false, logs, config);
        if (step == -1) {
            return height;
        }
        return step < 6 ? -1 : step;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int branchBase) {
            super(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

