/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FallenFirLogFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == Blocks.f_50440_;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60734_() instanceof BushBlock || world.m_8055_(pos).m_60734_() == Blocks.f_50125_;

    public FallenFirLogFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() > 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        int length = 5 + rand.m_188503_(5);
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
        int groundCheck = 0;
        boolean startConnected = false;
        boolean endConnected = false;
        int groundRequired = length % 2 == 0 ? length - 1 : length - 2;
        for (int i = 0; i < length; ++i) {
            if (!this.placeOn.matches(world, startPos.m_5484_(direction, i))) continue;
            if (i <= 1) {
                startConnected = true;
            }
            if (i >= length - 2) {
                endConnected = true;
            }
            ++groundCheck;
        }
        if (groundCheck < groundRequired) {
            if (!startConnected) {
                return false;
            }
            if (!endConnected) {
                return false;
            }
        }
        if (!this.checkSpace(world, startPos.m_7494_(), direction, length)) {
            return false;
        }
        BlockPos pos = startPos.m_7494_();
        for (int i = 0; i < length; ++i) {
            BlockState blockBelow;
            this.setBlock(world, pos.m_5484_(direction, i), (BlockState)((Block)BOPBlocks.FIR_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_()));
            BlockState blockAbove = world.m_8055_(pos.m_7494_().m_5484_(direction, i));
            if (blockAbove.m_60795_() || blockAbove.m_60734_() instanceof BushBlock || blockAbove.m_60734_() == Blocks.f_50125_) {
                if (rand.m_188503_(5) == 0) {
                    this.setBlock(world, pos.m_7494_().m_5484_(direction, i), ((Block)BOPBlocks.TOADSTOOL.get()).m_49966_());
                } else if (rand.m_188503_(4) == 0) {
                    this.setBlock(world, pos.m_7494_().m_5484_(direction, i), ((Block)BOPBlocks.SPROUT.get()).m_49966_());
                }
            }
            if ((blockBelow = world.m_8055_(pos.m_7495_().m_5484_(direction, i))).m_60795_() || blockBelow.m_60734_() instanceof BushBlock || blockBelow.m_60734_() == Blocks.f_50125_) {
                this.setBlock(world, pos.m_7495_().m_5484_(direction, i), Blocks.f_152548_.m_49966_());
            }
            if (!blockBelow.m_204336_(BlockTags.f_144274_)) continue;
            super.m_5974_((LevelWriter)world, pos.m_7495_().m_5484_(direction, i), Blocks.f_152549_.m_49966_());
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, Direction direction, int length) {
        for (int y = 0; y <= 2; ++y) {
            for (int i = 0; i < length; ++i) {
                BlockPos pos1 = pos.m_6630_(y).m_5484_(direction, i);
                if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                return false;
            }
        }
        return true;
    }
}

