/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.dynamo;

import cofh.api.core.ISecurable;
import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISteamInfo;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.container.IAugmentableContainer;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementDualScaled;
import cofh.core.gui.element.ElementEnergyStored;
import cofh.core.gui.element.tab.TabAugment;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabEnergy;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabRedstoneControl;
import cofh.core.gui.element.tab.TabSecurity;
import cofh.core.gui.element.tab.TabSteam;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class GuiDynamoBase
extends GuiContainerCore {
    protected TileDynamoBase baseTile;
    protected UUID playerName;
    protected TabBase energyTab;
    protected TabSteam steamTab;
    protected TabBase augmentTab;
    protected TabBase redstoneTab;
    protected TabBase securityTab;
    protected ElementDualScaled duration;

    public GuiDynamoBase(Container container, TileEntity tile, EntityPlayer player, ResourceLocation texture) {
        super(container, texture);
        this.baseTile = (TileDynamoBase)tile;
        this.name = this.baseTile.func_70005_c_();
        this.playerName = SecurityHelper.getID((EntityPlayer)player);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElement((ElementBase)new ElementEnergyStored((GuiContainerCore)this, 80, 18, this.baseTile.getEnergyStorage()));
        this.steamTab = (TabSteam)this.addTab((TabBase)new TabSteam((GuiContainerCore)this, (ISteamInfo)this.baseTile, this.baseTile.isSteamProducer()));
        this.steamTab.setVisible(this.baseTile.showSteamTab());
        this.augmentTab = this.addTab((TabBase)new TabAugment((GuiContainerCore)this, (IAugmentableContainer)this.field_147002_h));
        this.redstoneTab = this.addTab((TabBase)new TabRedstoneControl((GuiContainerCore)this, (IRedstoneControl)this.baseTile));
        this.redstoneTab.setVisible(this.baseTile.hasRedstoneControl());
        this.securityTab = this.addTab((TabBase)new TabSecurity((GuiContainerCore)this, (ISecurable)this.baseTile, this.playerName));
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
        this.energyTab = this.addTab((TabBase)new TabEnergy((GuiContainerCore)this, (IEnergyInfo)this.baseTile, true).displayStored(!this.baseTile.smallStorage()));
        this.energyTab.setVisible(this.baseTile.showEnergyTab());
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermalexpansion.dynamo.0")));
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_146281_b() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        super.func_146281_b();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.baseTile.canAccess()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.redstoneTab.setVisible(this.baseTile.hasRedstoneControl());
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
        this.energyTab.setVisible(this.baseTile.showEnergyTab());
        this.steamTab.setVisible(this.baseTile.showSteamTab());
        this.steamTab.setProducer(this.baseTile.isSteamProducer());
    }

    protected void updateElementInformation() {
        super.updateElementInformation();
        this.duration.setQuantity(this.baseTile.getScaledDuration(16));
    }

    @SubscribeEvent
    public void handleItemTooltipEvent(ItemTooltipEvent event) {
        if (this.baseTile.isSteamProducer()) {
            return;
        }
        int energy = this.baseTile.getFuelEnergy(event.getItemStack());
        if (energy > 0) {
            event.getToolTip().add("\u00a7a" + StringHelper.localize((String)"info.cofh.energy") + ": " + StringHelper.getScaledNumber((long)energy) + " RF" + "\u00a7r");
        }
    }
}

