/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.client.sprite;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.sprite.AtlasSpriteSwappable;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.misc.SpriteUtil;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class AtlasSpriteFluid
extends AtlasSpriteSwappable {
    final ResourceLocation fromName;
    final BCFluid fluid;
    final int colourLight;
    final int colourDark;

    public AtlasSpriteFluid(String baseName, ResourceLocation fromName, BCFluid fluid) {
        super(baseName);
        this.fromName = fromName;
        this.fluid = fluid;
        this.colourLight = fluid.getLightColour();
        this.colourDark = fluid.getDarkColour();
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        ResourceLocation from = SpriteUtil.transformLocation((ResourceLocation)this.fromName);
        TextureAtlasSprite sprite = AtlasSpriteFluid.loadSprite((IResourceManager)manager, (String)from.toString(), (ResourceLocation)from, (boolean)true);
        if (sprite == null) {
            BCLog.logger.warn("Unable to recolour " + from + " as it couldn't be loaded!");
            return true;
        }
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            this.recolourFrame(sprite, f);
        }
        this.swapWith(sprite);
        return false;
    }

    private void recolourFrame(TextureAtlasSprite sprite, int f) {
        int[][] frameData = sprite.func_147965_a(f);
        if (frameData != null) {
            int[] pixels = frameData[0];
            for (int i = 0; i < pixels.length; ++i) {
                this.recolourPixel(pixels, i);
            }
        }
    }

    private void recolourPixel(int[] pixels, int i) {
        int rgba = pixels[i];
        int r = this.recolourSubPixel(rgba, 0);
        int g = this.recolourSubPixel(rgba, 8);
        int b = this.recolourSubPixel(rgba, 16);
        int a = 255;
        pixels[i] = a << 24 | b << 16 | g << 8 | r;
    }

    private int recolourSubPixel(int rgba, int offset) {
        int data = rgba >>> offset & 0xFF;
        int dark = this.colourDark >>> offset & 0xFF;
        int light = this.colourLight >>> offset & 0xFF;
        return (dark * (256 - data) + light * data) / 256;
    }
}

