/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adlods.ore.Deposit;
import com.endertech.minecraft.mods.adlods.ore.DepositGenResult;
import com.endertech.minecraft.mods.adlods.ore.DepositSample;
import com.endertech.minecraft.mods.adlods.ore.Flowers;
import com.endertech.minecraft.mods.adlods.ore.Ore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class Generator
implements IWorldGenerator {
    protected final Path configsDir;
    protected final List<Deposit> deposits = new ArrayList<Deposit>();
    protected final Set<IBlockState> oreBlocks = new HashSet<IBlockState>();

    public Generator(Path configsDir) {
        this.configsDir = configsDir;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        DepositGenResult result;
        Deposit deposit2;
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        List passed = this.deposits.stream().filter(deposit -> deposit.inAllowableDimenstion(world) && deposit.getChance().takeChance()).collect(Collectors.toList());
        int maxAttempts = 8;
        for (int attempt = 0; attempt < maxAttempts && (deposit2 = (Deposit)CommonCollect.getRandomElementFrom(passed)) != null && (result = deposit2.generateAt(world, pos, true)).isEmpty(); ++attempt) {
        }
    }

    protected void createDefaultDeposits(Path dir) {
        this.createDeposit(dir, "coal", new Deposit.Size(900, 1800), new Deposit.Altitude(32, 80), 800, Flowers.circles(Flowers.GlowRose.ONYX, Flowers.Mystical.BLACK, Flowers.Vanilla.LARGE_FERN));
        DepositSample sample = new DepositSample(new Deposit.Size(700, 1400), new Deposit.Altitude(16, 64), new Deposit.Rarity(1000, 3000));
        this.createDeposit(dir, "iron", sample, 1.0f, Flowers.circles(Flowers.GlowRose.AMBER, Flowers.Mystical.BROWN, Flowers.Vanilla.ORANGE_TULIP, Flowers.Metal.CHEAP));
        this.createDeposit(dir, "aluminum", sample, 6.6f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.CHEAP));
        this.createDeposit(dir, "lead", sample, 7.0f, Flowers.circles(Flowers.GlowRose.ONYX, Flowers.Mystical.GRAY, Flowers.Vanilla.HOUSTONIA, Flowers.Metal.CHEAP));
        this.createDeposit(dir, "zinc", sample, 10.3f, Flowers.circles(Flowers.GlowRose.AQUAMARINE, Flowers.Mystical.LIGHT_BLUE, Flowers.Vanilla.BLUE_ORCHID, Flowers.Metal.NORMAL));
        this.createDeposit(dir, "copper", sample, 22.6f, Flowers.circles(Flowers.GlowRose.TOPAZ, Flowers.Mystical.ORANGE, Flowers.Vanilla.ORANGE_TULIP, Flowers.Metal.NORMAL));
        this.createDeposit(dir, "nickel", sample, 44.6f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.NORMAL));
        this.createDeposit(dir, "tin", sample, 74.8f, Flowers.circles(Flowers.GlowRose.HELIODOR, Flowers.Mystical.YELLOW, Flowers.Vanilla.OXEYE_DAISY, Flowers.Metal.NORMAL));
        this.createDeposit(dir, "cobalt", sample, 104.7f, Flowers.circles(Flowers.GlowRose.SAPPHIRE, Flowers.Mystical.BLUE, Flowers.Vanilla.BLUE_ORCHID, Flowers.Metal.NORMAL));
        sample = new DepositSample(new Deposit.Size(500, 1000), new Deposit.Altitude(8, 32), new Deposit.Rarity(1200, 3600));
        this.createDeposit(dir, "silver", sample, 1.0f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.GRAY, Flowers.Vanilla.HOUSTONIA, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "ruthenium", sample, 17.45f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "platinum", sample, 58.89f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.LIGHT_GRAY, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "gold", sample, 85.67f, Flowers.circles(Flowers.GlowRose.HELIODOR, Flowers.Mystical.ORANGE, Flowers.Vanilla.DANDELION, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "palladium", sample, 90.97f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "iridium", sample, 97.8f, Flowers.circles(Flowers.GlowRose.HELIODOR, Flowers.Mystical.YELLOW, Flowers.Vanilla.OXEYE_DAISY, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "uranium", sample, 100.0f, Flowers.circles(Flowers.GlowRose.BERYL, Flowers.Mystical.LIME, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        this.createDeposit(dir, "rhodium", sample, 211.94f, Flowers.circles(Flowers.GlowRose.OPAL, Flowers.Mystical.WHITE, Flowers.Vanilla.WHITE_TULIP, Flowers.Metal.PRECIOUS));
        sample = new DepositSample(new Deposit.Size(300, 600), new Deposit.Altitude(4, 16), new Deposit.Rarity(1400, 4200));
        this.createDeposit(dir, "redstone", sample, 60.0f, Flowers.circles(Flowers.GlowRose.GARNET, Flowers.Mystical.RED, Flowers.Vanilla.POPPY));
        this.createDeposit(dir, "lapis", sample, 80.0f, Flowers.circles(Flowers.GlowRose.SAPPHIRE, Flowers.Mystical.BLUE, Flowers.Vanilla.BLUE_ORCHID));
        this.createDeposit(dir, "diamond", sample, 100.0f, Flowers.circles(Flowers.GlowRose.AQUAMARINE, Flowers.Mystical.CYAN, Flowers.Vanilla.BLUE_ORCHID));
        this.createDeposit(dir, "amethyst", sample, 70.0f, Flowers.circles(Flowers.GlowRose.AMETHYST, Flowers.Mystical.PURPLE, Flowers.Vanilla.PINK_TULIP));
        this.createDeposit(dir, "sapphire", sample, 80.0f, Flowers.circles(Flowers.GlowRose.SAPPHIRE, Flowers.Mystical.BLUE, Flowers.Vanilla.BLUE_ORCHID));
        this.createDeposit(dir, "ruby", sample, 90.0f, Flowers.circles(Flowers.GlowRose.RUBY, Flowers.Mystical.RED, Flowers.Vanilla.RED_TULIP));
        this.createDeposit(dir, "topaz", sample, 100.0f, Flowers.circles(Flowers.GlowRose.TOPAZ, Flowers.Mystical.ORANGE, Flowers.Vanilla.ORANGE_TULIP));
        this.createDeposit(dir, "emerald", sample, 110.0f, Flowers.circles(Flowers.GlowRose.INDICOLITE, Flowers.Mystical.LIME, Flowers.Vanilla.WHITE_TULIP));
    }

    public Deposit createDeposit(Path dir, String name, DepositSample sample, float priceFactor) {
        return this.createDeposit(dir, name, sample, priceFactor, new String[0]);
    }

    public Deposit createDeposit(Path dir, String name, DepositSample sample, float priceFactor, String[] indicatorCircles) {
        float factor = new Percentage(priceFactor).toFraction();
        int rarity = sample.getRarity(factor);
        return this.createDeposit(dir, name, sample.size, sample.altitude, rarity, indicatorCircles);
    }

    public Deposit createDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity) {
        return this.createDeposit(dir, name, size, altitude, rarity, new String[0]);
    }

    public Deposit createDeposit(Path dir, String name, Deposit.Size size, Deposit.Altitude altitude, int rarity, String[] indicatorCircles) {
        return new Deposit(new UnitConfig(dir, name), size, altitude, rarity, new String[]{UnitId.buildDictName((String[])new String[]{"ore", name})}, new String[]{Dimensions.overworld.replaceableBlockId.toString()}, indicatorCircles);
    }

    protected void parseDepositsFrom(Path dir) {
        this.deposits.clear();
        String[] array = new String[]{};
        for (Path path : UnitConfig.listCustomConfigs((Path)dir, null)) {
            Deposit deposit = new Deposit(new UnitConfig(path.toFile()), Deposit.Size.ZERO, Deposit.Altitude.ZERO, 0, array, array, array);
            this.addDeposit(deposit);
        }
    }

    public Path getConfigsDir() {
        return this.configsDir;
    }

    public List<Deposit> getDeposits() {
        return Collections.unmodifiableList(this.deposits);
    }

    public void loadDeposits() {
        this.createDefaultDeposits(this.configsDir);
        this.parseDepositsFrom(this.configsDir);
        this.mapOreBlocks();
    }

    protected void mapOreBlocks() {
        this.oreBlocks.clear();
        for (Deposit deposit : this.deposits) {
            for (Ore ore : deposit.ores.getElements()) {
                IBlockState state = ore.getId().getIBlockState();
                if (state == null) continue;
                this.oreBlocks.add(state);
            }
        }
    }

    public boolean isOreBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (ForgeWorld.isAirBlock((IBlockState)state)) {
            return false;
        }
        return this.oreBlocks.contains(state) || ForgeWorld.isOreBlock((World)world, (BlockPos)pos);
    }

    public boolean addDeposit(Deposit deposit) {
        if (!deposit.isValid()) {
            return false;
        }
        if (this.findDepositBy(deposit.getName()) != null) {
            return false;
        }
        return this.deposits.add(deposit);
    }

    public boolean removeDeposit(Deposit deposit) {
        return this.deposits.remove(deposit);
    }

    @Nullable
    public Deposit findDepositBy(String name) {
        for (Deposit deposit : this.deposits) {
            if (!deposit.getName().equals(name)) continue;
            return deposit;
        }
        return null;
    }
}

