/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.mods.adlods.Command;
import com.endertech.minecraft.mods.adlods.ore.Generator;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaGen;
import java.nio.file.Path;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="adlods", name="Large Ore Deposits", version="1.12.2-1.0.8.0", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forgeendertech@[1.12.2-4.5.2.0,)")
public class Main
extends ForgeMod {
    public static final String ID = "adlods";
    public static final String NAME = "Large Ore Deposits";
    @Mod.Instance(value="adlods")
    public static Main instance;
    private Generator generator;
    private VanillaGen controller;

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ForgeMod getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.setConfig(new ModConfig(ID, event));
        super.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        super.init(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        super.initClient(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Command());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        Path configDir = this.getConfig().getConfigDir();
        this.generator = new Generator(configDir.resolve("Deposits"));
        this.generator.loadDeposits();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.generator, (int)0);
        this.controller = new VanillaGen(configDir.resolve("VanillaGen"));
        this.controller.loadOres();
        MinecraftForge.ORE_GEN_BUS.register((Object)this.controller);
        super.postInit(event);
    }

    public static Generator getGenerator() {
        return Main.instance.generator;
    }

    public static VanillaGen getVanillaGenController() {
        return Main.instance.controller;
    }
}

