/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.teleport;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import xaero.map.WorldMap;
import xaero.map.world.MapConnectionNode;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapTeleporter {
    public void teleport(GuiScreen screen, MapWorld mapWorld, int x, int y, int z, Integer d) {
        String tpCommand;
        Minecraft.func_71410_x().func_147108_a(null);
        if (Minecraft.func_71410_x().field_71442_b.func_78763_f()) {
            MapConnectionNode destinationMapKey;
            MapDimension destinationDim = mapWorld.getDimension(d != null ? d.intValue() : Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
            MapConnectionNode playerMapKey = mapWorld.getPlayerMapKey();
            if (playerMapKey == null) {
                TextComponentString messageComponent = new TextComponentString(I18n.func_135052_a((String)"gui.xaero_wm_teleport_never_confirmed", (Object[])new Object[0]));
                messageComponent.func_150255_a(messageComponent.func_150256_b().func_150238_a(TextFormatting.RED));
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
                return;
            }
            MapConnectionNode mapConnectionNode = destinationMapKey = destinationDim == null ? null : destinationDim.getSelectedMapKeyUnsynced();
            if (!mapWorld.getMapConnections().isConnected(playerMapKey, destinationMapKey)) {
                TextComponentString messageComponent = new TextComponentString(I18n.func_135052_a((String)"gui.xaero_wm_teleport_not_connected", (Object[])new Object[0]));
                messageComponent.func_150255_a(messageComponent.func_150256_b().func_150238_a(TextFormatting.RED));
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
                return;
            }
        }
        String string = tpCommand = d == null ? mapWorld.getTeleportCommandFormat() : mapWorld.getDimensionTeleportCommandFormat();
        String yString = y == -1 ? "~" : (WorldMap.settings.partialYTeleportation ? (double)y + 0.5 + "" : y + "");
        tpCommand = tpCommand.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z);
        if (d != null) {
            tpCommand = tpCommand.replace("{d}", d + "");
        }
        screen.func_175281_b(tpCommand, false);
        mapWorld.setCustomDimensionId(null);
        mapWorld.getMapProcessor().checkForWorldUpdate();
    }
}

