/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.region.MapBlock;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;
import xaero.map.world.MapDimension;

public class Overlay
extends MapPixel {
    private byte opacity;

    public Overlay(int state, int colourType, int customColour, byte light, boolean glowing) {
        this.write(state, colourType, customColour, light, glowing);
    }

    public void write(int state, int colourType, int customColour, byte light, boolean glowing) {
        this.opacity = 0;
        this.state = state;
        this.colourType = (byte)colourType;
        this.customColour = customColour;
        this.light = light;
        this.glowing = glowing;
    }

    public boolean isWater() {
        int id = this.state & 0xFFF;
        return (this.state & 0xFFFF0000) == 0 && (id == 9 || id == 8);
    }

    public int getParametres() {
        int parametres = 0;
        parametres |= !this.isWater() ? 1 : 0;
        parametres |= this.light << 4;
        int compatibleColourType = this.colourType >= 2 ? this.colourType - 1 : this.colourType;
        int colourTypeToWrite = compatibleColourType < 0 ? 0 : compatibleColourType & 3;
        parametres |= colourTypeToWrite << 8;
        return parametres |= (this.opacity & 0xF) << 11;
    }

    public void getPixelColour(MapBlock block, int[] result_dest, MapWriter mapWriter, World world, MapDimension dim, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, int caveStart, int caveDepth, BlockPos.MutableBlockPos mutableGlobalPos, float shadowR, float shadowG, float shadowB, BiomeColorCalculator biomeColorCalculator, MapProcessor mapProcessor, OverlayManager overlayManager) {
        super.getPixelColours(result_dest, mapWriter, world, dim, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, block, -1, -1, caveStart, caveDepth, null, mutableGlobalPos, shadowR, shadowG, shadowB, biomeColorCalculator, mapProcessor, overlayManager, null);
    }

    public String toString() {
        return "(S: " + this.getState() + ", CT: " + this.colourType + ", CC: " + this.getCustomColour() + ", O: " + this.opacity + ", L: " + this.light + ")";
    }

    public boolean equals(Overlay p) {
        return p != null && this.opacity == p.opacity && this.light == p.light && this.getState() == p.getState();
    }

    void fillManagerKeyHolder(Object[] keyHolder, int colourType, int customColour) {
        keyHolder[0] = this.state;
        keyHolder[1] = colourType;
        keyHolder[2] = customColour;
        keyHolder[3] = this.light;
        keyHolder[4] = this.opacity;
    }

    public void increaseOpacity(int toAdd) {
        this.opacity = (byte)(this.opacity + toAdd);
        if (this.opacity > 15) {
            this.opacity = (byte)15;
        }
    }

    public int getOpacity() {
        return this.opacity;
    }
}

