/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.basic;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;

public class ClientboundRulesPacket
extends WorldMapMessage<ClientboundRulesPacket> {
    public boolean allowCaveModeOnServer;
    public boolean allowNetherCaveModeOnServer;

    public ClientboundRulesPacket(boolean allowCaveModeOnServer, boolean allowNetherCaveModeOnServer) {
        this.allowCaveModeOnServer = allowCaveModeOnServer;
        this.allowNetherCaveModeOnServer = allowNetherCaveModeOnServer;
    }

    public ClientboundRulesPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt;
        PacketBuffer buffer = new PacketBuffer(buf);
        try {
            nbt = buffer.func_150793_b();
        }
        catch (IOException e) {
            return;
        }
        this.allowCaveModeOnServer = nbt.func_74767_n("cm");
        this.allowNetherCaveModeOnServer = nbt.func_74767_n("ncm");
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("cm", this.allowCaveModeOnServer);
        nbt.func_74757_a("ncm", this.allowNetherCaveModeOnServer);
        buffer.func_150786_a(nbt);
    }

    public static class ClientHandler
    implements ClientMessageConsumer<ClientboundRulesPacket> {
        @Override
        public void handle(ClientboundRulesPacket message) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().setSyncedRules(message);
        }
    }
}

