/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiButton;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.ModOptionButton;
import xaero.map.gui.ModOptionSlider;
import xaero.map.settings.ModOptions;

public class ConfigSettingEntry
implements ISettingEntry {
    public static final Set<ModOptions> FILE_ONLY_ENABLE = new HashSet<ModOptions>(Lists.newArrayList((Object[])new ModOptions[]{ModOptions.MAP_TELEPORT_ALLOWED}));
    private ModOptions option;

    public ConfigSettingEntry(ModOptions option) {
        this.option = option;
    }

    @Override
    public GuiButton createWidget(int x, int y, int w, int width, boolean canEditIngameSettings) {
        GuiButton widget = !this.option.getEnumFloat() ? new ModOptionButton(this.option, this.option.returnEnumOrdinal(), x, y, w, 20, WorldMap.settings.getKeyBinding(this.option)) : new ModOptionSlider(this.option, this.option.returnEnumOrdinal(), x, y, w, 20, width);
        boolean bl = widget.field_146124_l = !this.option.isDisabledBecauseNotIngame() && !this.option.isDisabledBecauseMinimap();
        if (widget.field_146124_l && FILE_ONLY_ENABLE.contains((Object)this.option) && !WorldMap.settings.getClientBooleanValue(this.option)) {
            widget.field_146124_l = false;
        }
        return widget;
    }

    @Override
    public String getStringForSearch() {
        String tooltipPart;
        CursorBox optionTooltip = this.option.getTooltip();
        String mainText = WorldMap.settings.getKeyBinding(this.option);
        if (optionTooltip != null) {
            tooltipPart = " " + optionTooltip.getPlainText();
            if (optionTooltip.getFullCode() != null) {
                tooltipPart = tooltipPart + " " + optionTooltip.getFullCode().replace("gui.xaero", "");
            }
        } else {
            tooltipPart = "";
        }
        return mainText + " " + this.option.getEnumStringRaw().replace("gui.xaero", "") + tooltipPart;
    }

    public int hashCode() {
        return this.option.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ConfigSettingEntry && ((ConfigSettingEntry)obj).option == this.option;
    }
}

