/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import java.nio.file.Path;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import xaero.map.WorldMap;
import xaero.map.common.config.CommonConfig;
import xaero.map.message.basic.ClientboundRulesPacket;
import xaero.map.message.basic.HandshakePacket;
import xaero.map.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.MineraftServerDataInitializer;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.player.IServerPlayer;
import xaero.map.server.player.ServerPlayerData;

public class CommonEvents {
    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        if (oldPlayer instanceof EntityPlayerMP) {
            EntityPlayer newPlayer = event.getEntityPlayer();
            ((IServerPlayer)newPlayer).setXaeroWorldMapPlayerData(ServerPlayerData.get((EntityPlayerMP)oldPlayer));
        }
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        new MineraftServerDataInitializer().init(event.getServer());
    }

    public void onServerStopped(FMLServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            WorldMap.messageHandler.sendToPlayer((EntityPlayerMP)player, new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(EntityPlayerMP player) {
        WorldMap.messageHandler.sendToPlayer(player, new HandshakePacket());
        CommonConfig config = WorldMap.commonConfig;
        WorldMap.messageHandler.sendToPlayer(player, new ClientboundRulesPacket(config.allowCaveModeOnServer, config.allowNetherCaveModeOnServer));
        MinecraftServer mcServer = player.field_70170_p.func_73046_m();
        Path propertiesPath = mcServer.func_71254_M().func_186352_b(mcServer.func_71270_I(), "xaeromap.txt").toPath();
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.func_184102_h());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            WorldMap.messageHandler.sendToPlayer(player, properties);
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            player.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("gui.xaero_wm_error_loading_properties", new Object[0]));
        }
    }

    @SubscribeEvent
    public void handlePlayerTickStart(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            WorldMap.serverPlayerTickHandler.tick((EntityPlayerMP)player);
            return;
        }
    }
}

