/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.net.lenni0451.reflect.accessor.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import unilib.external.net.lenni0451.reflect.Constructors;
import unilib.external.net.lenni0451.reflect.Methods;
import unilib.external.net.lenni0451.reflect.wrapper.ASMWrapper;

public class ASMMethodAccessor {
    public static <I> I makeInvoker(@Nonnull Class<I> invokerClass, Object instance, @Nonnull Method method) {
        String newClassName = ASMWrapper.slash(method.getDeclaringClass()) + "$MethodInvoker";
        boolean staticMethod = Modifier.isStatic(method.getModifiers());
        Method invokerMethod = ASMMethodAccessor.findInvokerMethod(invokerClass, method, false);
        ASMWrapper acc = ASMWrapper.create(ASMWrapper.opcode("ACC_SUPER") | ASMWrapper.opcode("ACC_FINAL") | ASMWrapper.opcode("ACC_SYNTHETIC"), newClassName, null, "java/lang/Object", new String[]{ASMWrapper.slash(invokerClass)});
        if (staticMethod) {
            ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), "<init>", "()V", null, null);
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitMethodInsn(ASMWrapper.opcode("INVOKESPECIAL"), "java/lang/Object", "<init>", "()V", false);
            mv.visitInsn(ASMWrapper.opcode("RETURN"));
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        } else {
            String instanceType = ASMWrapper.desc(instance.getClass());
            acc.visitField(ASMWrapper.opcode("ACC_PRIVATE"), "instance", instanceType, null, null);
            ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), "<init>", "(" + instanceType + ")V", null, null);
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitMethodInsn(ASMWrapper.opcode("INVOKESPECIAL"), "java/lang/Object", "<init>", "()V", false);
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 1);
            mv.visitFieldInsn(ASMWrapper.opcode("PUTFIELD"), newClassName, "instance", instanceType);
            mv.visitInsn(ASMWrapper.opcode("RETURN"));
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
        String methodClass = ASMWrapper.slash(method.getDeclaringClass());
        String methodDesc = ASMWrapper.desc(method);
        boolean interfaceMethod = Modifier.isInterface(method.getDeclaringClass().getModifiers());
        ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), invokerMethod.getName(), ASMWrapper.desc(invokerMethod), null, null);
        if (staticMethod) {
            ASMMethodAccessor.pushArgs(mv, invokerMethod.getParameterTypes(), method.getParameterTypes());
            mv.visitMethodInsn(ASMWrapper.opcode("INVOKESTATIC"), methodClass, method.getName(), methodDesc, interfaceMethod);
        } else {
            mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
            mv.visitFieldInsn(ASMWrapper.opcode("GETFIELD"), newClassName, "instance", ASMWrapper.desc(instance.getClass()));
            ASMMethodAccessor.pushArgs(mv, invokerMethod.getParameterTypes(), method.getParameterTypes());
            if (interfaceMethod) {
                mv.visitMethodInsn(ASMWrapper.opcode("INVOKEINTERFACE"), methodClass, method.getName(), methodDesc, true);
            } else {
                mv.visitMethodInsn(ASMWrapper.opcode("INVOKEVIRTUAL"), methodClass, method.getName(), methodDesc, false);
            }
        }
        if (!method.getReturnType().equals(invokerMethod.getReturnType())) {
            mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(invokerMethod.getReturnType()));
        }
        mv.visitInsn(ASMWrapper.getReturnOpcode(invokerMethod.getReturnType()));
        mv.visitMaxs(invokerMethod.getParameterCount() + 1, invokerMethod.getParameterCount() + 1);
        mv.visitEnd();
        Class<?> clazz = acc.defineMetafactory(method.getDeclaringClass());
        if (Modifier.isStatic(method.getModifiers())) {
            Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
            return (I)Constructors.invoke(constructor, new Object[0]);
        }
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, instance.getClass());
        return (I)Constructors.invoke(constructor, instance);
    }

    public static <I> I makeDynamicInvoker(@Nonnull Class<I> invokerClass, @Nonnull Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Dynamic invoker can only be used for non-static methods");
        }
        String newClassName = ASMWrapper.slash(method.getDeclaringClass()) + "$DynamicMethodInvoker";
        Method invokerMethod = ASMMethodAccessor.findInvokerMethod(invokerClass, method, true);
        ASMWrapper acc = ASMWrapper.create(ASMWrapper.opcode("ACC_SUPER") | ASMWrapper.opcode("ACC_FINAL") | ASMWrapper.opcode("ACC_SYNTHETIC"), newClassName, null, "java/lang/Object", new String[]{ASMWrapper.slash(invokerClass)});
        ASMWrapper.MethodVisitorAccess mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), "<init>", "()V", null, null);
        mv.visitVarInsn(ASMWrapper.opcode("ALOAD"), 0);
        mv.visitMethodInsn(ASMWrapper.opcode("INVOKESPECIAL"), "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(ASMWrapper.opcode("RETURN"));
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = acc.visitMethod(ASMWrapper.opcode("ACC_PUBLIC"), invokerMethod.getName(), ASMWrapper.desc(invokerMethod), null, null);
        ASMMethodAccessor.pushArgs(mv, invokerMethod.getParameterTypes(), ASMMethodAccessor.prepend(method.getParameterTypes(), method.getDeclaringClass()));
        if (Modifier.isInterface(method.getDeclaringClass().getModifiers())) {
            mv.visitMethodInsn(ASMWrapper.opcode("INVOKEINTERFACE"), ASMWrapper.slash(method.getDeclaringClass()), method.getName(), ASMWrapper.desc(method), true);
        } else {
            mv.visitMethodInsn(ASMWrapper.opcode("INVOKEVIRTUAL"), ASMWrapper.slash(method.getDeclaringClass()), method.getName(), ASMWrapper.desc(method), false);
        }
        if (!method.getReturnType().equals(invokerMethod.getReturnType())) {
            mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(invokerMethod.getReturnType()));
        }
        mv.visitInsn(ASMWrapper.getReturnOpcode(invokerMethod.getReturnType()));
        mv.visitMaxs(invokerMethod.getParameterCount() + 1, invokerMethod.getParameterCount() + 1);
        mv.visitEnd();
        Class<?> clazz = acc.defineMetafactory(method.getDeclaringClass());
        Constructor<?> constructor = Constructors.getDeclaredConstructor(clazz, new Class[0]);
        return (I)Constructors.invoke(constructor, new Object[0]);
    }

    private static Method findInvokerMethod(Class<?> invokerClass, Method method, boolean requireInstance) {
        if (!Modifier.isInterface(invokerClass.getModifiers())) {
            throw new IllegalArgumentException("The invoker class must be an interface");
        }
        int abstractMethods = 0;
        Method matched = null;
        for (Method invokerMethod : Methods.getDeclaredMethods(invokerClass)) {
            if (!Modifier.isAbstract(invokerMethod.getModifiers())) continue;
            if (++abstractMethods > 1) {
                throw new IllegalArgumentException("The invoker class must only have one abstract method");
            }
            if (invokerMethod.getParameterCount() != method.getParameterCount() + (requireInstance ? 1 : 0)) {
                throw new IllegalArgumentException("The invoker method must have " + (method.getParameterCount() + (requireInstance ? 1 : 0)) + " parameters");
            }
            if (!invokerMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("The invoker method return type must be of type " + method.getReturnType().getName());
            }
            Class<?>[] invokerParameterTypes = invokerMethod.getParameterTypes();
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            for (int i = 0; i < invokerParameterTypes.length; ++i) {
                Class<?> methodParameterType;
                Class<?> invokerParameterType = invokerParameterTypes[i];
                Class<?> clazz = requireInstance && i == 0 ? method.getDeclaringClass() : (methodParameterType = methodParameterTypes[i - (requireInstance ? 1 : 0)]);
                if (invokerParameterType.isAssignableFrom(methodParameterType)) continue;
                throw new IllegalArgumentException("The invoker method parameter " + i + " must be of type " + methodParameterType);
            }
            matched = invokerMethod;
        }
        if (matched == null) {
            throw new IllegalArgumentException("Could not find a valid invoker method for: " + method);
        }
        return matched;
    }

    private static void pushArgs(ASMWrapper.MethodVisitorAccess mv, Class<?>[] supplied, Class<?>[] target) {
        int stack = 1;
        for (int i = 0; i < supplied.length; ++i) {
            Class<?> suppliedType = supplied[i];
            Class<?> targetType = target[i];
            mv.visitVarInsn(ASMWrapper.getLoadOpcode(suppliedType), stack);
            if (!suppliedType.equals(targetType)) {
                mv.visitTypeInsn(ASMWrapper.opcode("CHECKCAST"), ASMWrapper.slash(targetType));
            }
            stack += ASMMethodAccessor.getStackSize(suppliedType);
        }
    }

    private static int getStackSize(Class<?> clazz) {
        if (Long.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) {
            return 2;
        }
        return 1;
    }

    private static Class<?>[] prepend(Class<?>[] classes, Class<?> other) {
        Class[] newClasses = new Class[classes.length + 1];
        newClasses[0] = other;
        System.arraycopy(classes, 0, newClasses, 1, classes.length);
        return newClasses;
    }
}

