/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdagaming.unicore.utils;

import io.github.cdagaming.unicore.UniCore;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public class UrlUtils {
    private static final String USER_AGENT = "unicore/v1.2.5";
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static final int HTTP_TIMEOUT_SECS = Integer.getInteger("http.timeoutSecs", 15);

    public static String getURLText(URL url, String encoding) throws Exception {
        return UrlUtils.readerToString(UrlUtils.getURLReader(url, encoding));
    }

    public static String readerToString(BufferedReader reader) throws Exception {
        String response = reader.lines().collect(Collectors.joining("\n"));
        reader.close();
        return response;
    }

    public static String getURLText(String url, String encoding) throws Exception {
        return UrlUtils.readerToString(UrlUtils.getURLReader(url, encoding));
    }

    public static BufferedReader getURLReader(String url, String encoding) throws Exception {
        return UrlUtils.getURLReader(new URL(url), encoding);
    }

    public static BufferedReader getURLReader(URL url, String encoding) throws Exception {
        return new BufferedReader(UrlUtils.getURLStreamReader(url, encoding));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static InputStream getURLStream(URL url) throws Exception {
        String encoding;
        boolean isGzipEncoded;
        URLConnection connection;
        if (OSUtils.JAVA_SPEC < 1.8f) {
            System.setProperty("https.protocols", "TLSv1.2");
        }
        URL currentUrl = url;
        int redirects = 0;
        while (true) {
            if (redirects >= MAX_HTTP_REDIRECTS) {
                throw new IOException("Too many redirects while trying to fetch " + url);
            }
            connection = url.openConnection();
            connection.addRequestProperty("Accept-Encoding", "gzip");
            connection.addRequestProperty("User-Agent", USER_AGENT);
            connection.setConnectTimeout(HTTP_TIMEOUT_SECS * 1000);
            if (!(connection instanceof HttpURLConnection)) break;
            HttpURLConnection huc = (HttpURLConnection)connection;
            huc.setInstanceFollowRedirects(false);
            int responseCode = huc.getResponseCode();
            if (responseCode < 300 || responseCode > 399) break;
            String loc = huc.getHeaderField("Location");
            if (StringUtils.isNullOrEmpty(loc)) {
                throw new IOException("Got a 3xx response code but Location header was null while trying to fetch " + url);
            }
            currentUrl = new URL(currentUrl, loc);
            ++redirects;
        }
        boolean bl = isGzipEncoded = !StringUtils.isNullOrEmpty(encoding = connection.getContentEncoding()) && encoding.equals("gzip");
        if (isGzipEncoded) {
            return new GZIPInputStream(connection.getInputStream());
        }
        return connection.getInputStream();
    }

    public static InputStreamReader getURLStreamReader(URL url, String encoding) throws Exception {
        return new InputStreamReader(UrlUtils.getURLStream(url), Charset.forName(encoding));
    }

    public static boolean openUrl(String targetUrl) {
        try {
            return UrlUtils.openUrl(new URI(targetUrl));
        }
        catch (Exception ex) {
            UniCore.LOG.debugError(ex);
            return false;
        }
    }

    public static boolean openUrl(URL targetUrl) {
        try {
            return UrlUtils.openUrl(targetUrl.toURI());
        }
        catch (Exception ex) {
            UniCore.LOG.debugError(ex);
            return false;
        }
    }

    public static boolean openUrl(URI targetUrl) {
        if (UrlUtils.browseWithDesktop(targetUrl)) {
            return true;
        }
        if (OSUtils.browseWithSystem(targetUrl.toString())) {
            return true;
        }
        UniCore.LOG.error("Failed to go to page: %s", targetUrl.toString());
        return false;
    }

    public static boolean browseWithDesktop(URI uri) {
        try {
            if (!Desktop.isDesktopSupported()) {
                UniCore.LOG.debugInfo("Platform is not supported.", new Object[0]);
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                UniCore.LOG.debugInfo("BROWSE is not supported.", new Object[0]);
                return false;
            }
            UniCore.LOG.debugInfo("Trying to use Desktop.getDesktop().browse() with " + uri.toString(), new Object[0]);
            Desktop.getDesktop().browse(uri);
            return true;
        }
        catch (Throwable t) {
            UniCore.LOG.debugError("Error using desktop browse.", t);
            return false;
        }
    }
}

