/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.EntryListPane;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={StringEntry.class})
public class ScrollableListControl
extends EntryListPane<StringEntry> {
    public static final int DEFAULT_SLOT_HEIGHT = 18;
    public String currentValue;
    public List<String> itemList;

    public ScrollableListControl(@Nonnull Minecraft mc, ExtendedScreen parentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        super(mc, width, height, topIn, slotHeightIn);
        this.setParent(parentScreen);
        this.setList(itemList);
        this.currentValue = currentValue;
    }

    public ScrollableListControl(@Nonnull Minecraft mc, ExtendedScreen parentScreen, int width, int height, int topIn, int bottomIn, List<String> itemList, String currentValue) {
        this(mc, parentScreen, width, height, topIn, bottomIn, 18, itemList, currentValue);
    }

    @Override
    public void setSelected(StringEntry entry) {
        super.setSelected(entry);
        if (entry != null) {
            this.currentValue = entry.jvmdowngrader$nest$com_gitlab_cdagaming_unilib_utils_gui_controls_ScrollableListControl$StringEntry$get$name();
        }
    }

    @Override
    protected int getItemCount() {
        return this.itemList.size();
    }

    public boolean setList(List<String> itemList) {
        if (itemList == null) {
            itemList = StringUtils.newArrayList();
        }
        if (!itemList.equals(this.itemList)) {
            this.itemList = itemList;
            this.scrollBy(-2.1474836E9f);
            return true;
        }
        return false;
    }

    public void renderSlotItem(String originalName, int xPos, int yPos, int widthIn, int heightIn, int mouseXIn, int mouseYIn, boolean hovered, float partialTicks) {
        RenderUtils.renderScrollingString(this.getGameInstance(), this.getFontRenderer(), originalName, xPos + RenderUtils.getStringWidth(this.getFontRenderer(), originalName) / 2, xPos, yPos, xPos + widthIn - 4, yPos + heightIn, 0xFFFFFF);
    }

    @NestHost(value=ScrollableListControl.class)
    public class StringEntry
    extends EntryListPane.Entry<StringEntry> {
        private final String name;

        public StringEntry(String name) {
            this.name = name;
        }

        @Override
        public void render(Minecraft client, int index, int yPos, int xPos, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            ScrollableListControl.this.renderSlotItem(this.name, xPos, yPos, entryWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (ScrollableListControl.this.isValidMouseClick(button)) {
                this.onPressed();
                return true;
            }
            return false;
        }

        private void onPressed() {
            ScrollableListControl.this.setSelected(this);
        }

        String jvmdowngrader$nest$com_gitlab_cdagaming_unilib_utils_gui_controls_ScrollableListControl$StringEntry$get$name() {
            return this.name;
        }

        void jvmdowngrader$nest$com_gitlab_cdagaming_unilib_utils_gui_controls_ScrollableListControl$StringEntry$set$name(String string) {
            this.name = string;
        }
    }
}

