/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.runtime;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.ingredients.IIngredientSubtypeInterpreter;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SubtypeRegistry
implements ISubtypeRegistry {
    private final Map<Object, IIngredientSubtypeInterpreter<?>> interpreters = new Reference2ObjectOpenHashMap();

    @Override
    public void useNbtForSubtypes(Item ... items) {
        for (Item item : items) {
            this.registerSubtypeInterpreter(item, ItemAllNbt.INSTANCE);
        }
    }

    @Override
    public void useNbtForSubtypes(Fluid ... fluids) {
        for (Fluid fluid : fluids) {
            this.registerSubtypeInterpreter(fluid, FluidAllNbt.INSTANCE);
        }
    }

    @Override
    public void registerNbtInterpreter(Item item, ISubtypeRegistry.ISubtypeInterpreter interpreter) {
        this.registerSubtypeInterpreter(item, interpreter);
    }

    @Override
    public void registerSubtypeInterpreter(Item item, ISubtypeRegistry.ISubtypeInterpreter interpreter) {
        ErrorUtil.checkNotNull(item, "item");
        ErrorUtil.checkNotNull(interpreter, "interpreter");
        if (this.interpreters.containsKey(item)) {
            Log.get().error("An interpreter is already registered for this item: {}", (Object)item, (Object)new IllegalArgumentException());
            return;
        }
        this.interpreters.put(item, interpreter);
    }

    @Override
    public void registerSubtypeInterpreter(Fluid fluid, ISubtypeRegistry.IFluidSubtypeInterpreter interpreter) {
        ErrorUtil.checkNotNull(fluid, "fluid");
        ErrorUtil.checkNotNull(interpreter, "interpreter");
        if (this.interpreters.containsKey(fluid)) {
            Log.get().error("An interpreter is already registered for this fluid: {}", (Object)fluid, (Object)new IllegalArgumentException());
            return;
        }
        this.interpreters.put(fluid, interpreter);
    }

    @Override
    @Nullable
    public String getSubtypeInfo(ItemStack itemStack) {
        ErrorUtil.checkNotEmpty(itemStack);
        Item item = itemStack.func_77973_b();
        IIngredientSubtypeInterpreter<?> interpreter = this.interpreters.get(item);
        if (interpreter != null) {
            return interpreter.apply(itemStack);
        }
        return null;
    }

    @Override
    @Nullable
    public String getSubtypeInfo(FluidStack fluidStack) {
        ErrorUtil.checkNotNull(fluidStack, "fluid");
        Fluid fluid = fluidStack.getFluid();
        IIngredientSubtypeInterpreter<?> interpreter = this.interpreters.get(fluid);
        if (interpreter != null) {
            return interpreter.apply(fluidStack);
        }
        if (fluidStack.tag != null) {
            return fluidStack.tag.toString();
        }
        return null;
    }

    @Override
    public boolean hasSubtypeInterpreter(ItemStack itemStack) {
        ErrorUtil.checkNotEmpty(itemStack);
        return this.interpreters.containsKey(itemStack.func_77973_b());
    }

    @Override
    public boolean hasSubtypeInterpreter(FluidStack fluidStack) {
        ErrorUtil.checkNotNull(fluidStack, "fluidStack");
        return this.interpreters.containsKey(fluidStack.getFluid());
    }

    private static final class FluidAllNbt
    implements ISubtypeRegistry.IFluidSubtypeInterpreter {
        public static final FluidAllNbt INSTANCE = new FluidAllNbt();

        private FluidAllNbt() {
        }

        @Override
        public String apply(FluidStack fluidStack) {
            if (fluidStack.tag == null || fluidStack.tag.func_82582_d()) {
                return "";
            }
            return fluidStack.tag.toString();
        }
    }

    private static final class ItemAllNbt
    implements ISubtypeRegistry.ISubtypeInterpreter {
        public static final ItemAllNbt INSTANCE = new ItemAllNbt();

        private ItemAllNbt() {
        }

        @Override
        public String apply(ItemStack itemStack) {
            NBTTagCompound nbtTagCompound = itemStack.func_77978_p();
            if (nbtTagCompound == null || nbtTagCompound.func_82582_d()) {
                return "";
            }
            return nbtTagCompound.toString();
        }
    }
}

