/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import josephcsible.oreberries.OreberriesMod;
import josephcsible.oreberries.config.GeneralConfig;
import josephcsible.oreberries.config.OreberryConfig;
import josephcsible.oreberries.item.ItemEssenceBerry;
import josephcsible.oreberries.item.ItemOreberry;
import josephcsible.oreberries.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockOreberryBush
extends Block
implements IPlantable,
IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    protected static final AxisAlignedBB[] OREBERRY_BUSH_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    protected static final AxisAlignedBB[] OREBERRY_BUSH_COLLISION_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875), new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375)};
    public final ItemOreberry berries;
    public final OreberryConfig config;

    public BlockOreberryBush(String name, OreberryConfig config) {
        super(Material.field_151584_j);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(CommonProxy.creativeTab);
        this.func_149663_c("oreberries.oreberry_bush");
        this.setRegistryName("oreberries", name + "_oreberry_bush");
        this.config = config;
        this.berries = ItemEssenceBerry.isEssence(config.special) ? new ItemEssenceBerry(config.berryName, config.tooltip) : new ItemOreberry(config.berryName, config.tooltip);
        this.berries.setRegistryName("oreberries", name + "_oreberry");
    }

    public String func_149732_F() {
        return this.config.bushName;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return OREBERRY_BUSH_AABB[Math.min((Integer)state.func_177229_b((IProperty)AGE), 2)];
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return OREBERRY_BUSH_COLLISION_AABB[Math.min((Integer)state.func_177229_b((IProperty)AGE), 2)];
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        this.harvest(worldIn, pos, worldIn.func_180495_p(pos), playerIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.harvest(worldIn, pos, state, playerIn);
    }

    public ItemStack getBerriesStack(Random rand) {
        return new ItemStack((Item)this.berries, rand.nextInt(this.config.maxDrops - this.config.minDrops + 1) + this.config.minDrops);
    }

    protected boolean harvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if ((Integer)state.func_177229_b((IProperty)AGE) >= 3) {
            if (world.field_72995_K) {
                return true;
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.getBerriesStack(world.field_73012_v));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return OreberriesMod.proxy.isOreberryBushOpaqueCube(state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess blockAccess, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState touchingState;
        if (side != EnumFacing.DOWN && (Integer)state.func_177229_b((IProperty)AGE) < 2) {
            return true;
        }
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j && (touchingState = blockAccess.func_180495_p(pos.func_177972_a(side))).func_177230_c() == this && (Integer)touchingState.func_177229_b((IProperty)AGE) >= 2) {
            return false;
        }
        boolean thisShouldNotBeDeprecated = super.func_176225_a(state, blockAccess, pos, side);
        return thisShouldNotBeDeprecated;
    }

    protected boolean ageAndLightOkayToGrow(World worldIn, BlockPos pos, IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3 && (this.config.growsInLight || worldIn.func_175699_k(pos) < 10);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && this.ageAndLightOkayToGrow(worldIn, pos, state) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextDouble() < GeneralConfig.tickGrowthChance ? 1 : 0) != 0)) {
            this.func_176474_b(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable instanceof BlockOreberryBush) {
            return (Integer)state.func_177229_b((IProperty)AGE) > 1;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && (this.config.growsInLight || worldIn.func_175699_k(pos) < 13) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) && worldIn.func_175623_d(pos);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Cave;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!(entityIn instanceof EntityItem)) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_CACTUS;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return GeneralConfig.bonemealGrowthChance > 0.0 && this.ageAndLightOkayToGrow(worldIn, pos, state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return rand.nextDouble() < GeneralConfig.bonemealGrowthChance;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) + 1)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltips, ITooltipFlag advanced) {
        if (this.config.tooltip != null) {
            tooltips.add(this.config.tooltip);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return player != null && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) >= GeneralConfig.silkTouchRequirement;
    }

    public int func_149745_a(Random random) {
        return GeneralConfig.silkTouchRequirement == 0 ? super.func_149745_a(random) : 0;
    }
}

