/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerInternalSided;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEvent;
import buildcraft.api.transport.pipe.PipeEventStatement;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import buildcraft.transport.statements.TriggerPipeSignal;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public enum TriggerProviderPipes implements ITriggerProvider
{
    INSTANCE;


    public void addInternalTriggers(Collection<ITriggerInternal> triggers, IStatementContainer container) {
        if (container instanceof IGate) {
            IGate gate = (IGate)container;
            IPipeHolder holder = gate.getPipeHolder();
            holder.fireEvent((PipeEvent)new PipeEventStatement.AddTriggerInternal(holder, triggers));
            for (EnumDyeColor colour : ColourUtil.COLOURS) {
                if (!TriggerPipeSignal.doesGateHaveColour(gate, colour)) continue;
                triggers.add(BCTransportStatements.TRIGGER_PIPE_SIGNAL[colour.ordinal() * 2 + 0]);
                triggers.add(BCTransportStatements.TRIGGER_PIPE_SIGNAL[colour.ordinal() * 2 + 1]);
            }
            if (holder.getPipe().getFlow() instanceof PipeFlowPower) {
                triggers.add(BCTransportStatements.TRIGGER_POWER_REQUESTED);
            }
        }
    }

    public void addInternalSidedTriggers(Collection<ITriggerInternalSided> triggers, IStatementContainer container, @Nonnull EnumFacing side) {
        if (container instanceof IGate) {
            IGate gate = (IGate)container;
            IPipeHolder holder = gate.getPipeHolder();
            holder.fireEvent((PipeEvent)new PipeEventStatement.AddTriggerInternalSided(holder, triggers, side));
        }
    }

    public void addExternalTriggers(Collection<ITriggerExternal> triggers, @Nonnull EnumFacing side, TileEntity tile) {
    }
}

