/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.transport.IWireEmitter;
import buildcraft.core.statements.BCStatement;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.statements.ActionParameterSignal;
import java.util.Locale;
import net.minecraft.item.EnumDyeColor;

public class ActionPipeSignal
extends BCStatement
implements IActionInternal {
    public final EnumDyeColor colour;

    public ActionPipeSignal(EnumDyeColor colour) {
        super(new String[]{"buildcraft:pipe.wire.output." + colour.name().toLowerCase(Locale.ROOT), "buildcraft.pipe.wire.output." + colour.name().toLowerCase(Locale.ROOT)});
        this.colour = colour;
    }

    public String getDescription() {
        return String.format(LocaleUtil.localize((String)"gate.action.pipe.wire"), ColourUtil.getTextFullTooltip((EnumDyeColor)this.colour));
    }

    public int maxParameters() {
        return 3;
    }

    public IStatementParameter createParameter(int index) {
        return ActionParameterSignal.EMPTY;
    }

    public void actionActivate(IStatementContainer container, IStatementParameter[] parameters) {
        if (!(container instanceof IWireEmitter)) {
            return;
        }
        IWireEmitter emitter = (IWireEmitter)container;
        emitter.emitWire(this.colour);
        for (IStatementParameter param : parameters) {
            ActionParameterSignal signal;
            if (param == null || !(param instanceof ActionParameterSignal) || (signal = (ActionParameterSignal)param).getColor() == null) continue;
            emitter.emitWire(signal.getColor());
        }
    }

    public SpriteHolderRegistry.SpriteHolder getSprite() {
        return BCTransportSprites.getPipeSignal(true, this.colour);
    }

    public ActionPipeSignal[] getPossible() {
        return BCTransportStatements.ACTION_PIPE_SIGNAL;
    }
}

