/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.tile.TilePipeHolder;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public final class PluggableHolder {
    private static final IdAllocator ID_ALLOC = new IdAllocator("PlugHolder");
    public static final int ID_REMOVE_PLUG = ID_ALLOC.allocId("REMOVE_PLUG");
    public static final int ID_UPDATE_PLUG = ID_ALLOC.allocId("UPDATE_PLUG");
    public static final int ID_CREATE_PLUG = ID_ALLOC.allocId("CREATE_PLUG");
    public final TilePipeHolder holder;
    public final EnumFacing side;
    public PipePluggable pluggable;

    public PluggableHolder(TilePipeHolder holder, EnumFacing side) {
        this.holder = holder;
        this.side = side;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.pluggable != null) {
            nbt.func_74778_a("id", this.pluggable.definition.identifier.toString());
            nbt.func_74782_a("data", (NBTBase)this.pluggable.writeToNbt());
        }
        return nbt;
    }

    public void readFromNbt(NBTTagCompound nbt) {
        if (nbt.func_82582_d()) {
            this.pluggable = null;
            return;
        }
        String id = nbt.func_74779_i("id");
        NBTTagCompound data = nbt.func_74775_l("data");
        ResourceLocation identifier = new ResourceLocation(id);
        PluggableDefinition def = PipeApi.pluggableRegistry.getDefinition(identifier);
        if (def == null) {
            BCLog.logger.warn("Unknown pluggable id '" + id + "'");
            throw new Error("Def was null!");
        }
        this.pluggable = def.readFromNbt((IPipeHolder)this.holder, this.side, data);
        this.holder.eventBus.registerHandler(this.pluggable);
    }

    public void sendNewPluggableData() {
        this.holder.sendMessage(IPipeHolder.PipeMessageReceiver.PLUGGABLES[this.side.ordinal()], this::writeCreationPayload);
    }

    public void writeCreationPayload(PacketBuffer buffer) {
        if (this.pluggable == null) {
            buffer.writeByte(ID_REMOVE_PLUG);
        } else {
            buffer.writeByte(ID_CREATE_PLUG);
            buffer.func_180714_a(this.pluggable.definition.identifier.toString());
            this.pluggable.writeCreationPayload(buffer);
        }
    }

    public void readCreationPayload(PacketBuffer buffer) throws InvalidInputDataException {
        short id = buffer.readUnsignedByte();
        if (id == ID_CREATE_PLUG) {
            this.readCreateInternal(buffer);
        } else if (id == ID_REMOVE_PLUG) {
            this.holder.eventBus.unregisterHandler(this.pluggable);
            this.pluggable = null;
        } else {
            throw new InvalidInputDataException("Invalid ID for creation! " + ID_ALLOC.getNameFor((int)id));
        }
    }

    private void readCreateInternal(PacketBuffer buffer) throws InvalidInputDataException {
        ResourceLocation identifier = new ResourceLocation(buffer.func_150789_c(256));
        PluggableDefinition def = PipeApi.pluggableRegistry.getDefinition(identifier);
        if (def == null) {
            throw new InvalidInputDataException("Unknown remote pluggable \"" + identifier + "\"");
        }
        if (this.pluggable != null) {
            this.holder.eventBus.unregisterHandler(this.pluggable);
        }
        this.pluggable = def.loadFromBuffer((IPipeHolder)this.holder, this.side, buffer);
        this.holder.eventBus.registerHandler(this.pluggable);
    }

    public void writePayload(PacketBufferBC buffer, Side netSide) {
        if (netSide == Side.CLIENT) {
            buffer.writeByte(ID_UPDATE_PLUG);
            if (this.pluggable != null) {
                this.pluggable.writePayload((PacketBuffer)buffer, netSide);
            }
        } else if (this.pluggable == null) {
            buffer.writeByte(ID_REMOVE_PLUG);
        } else {
            buffer.writeByte(ID_UPDATE_PLUG);
            this.pluggable.writePayload((PacketBuffer)buffer, netSide);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readPayload(PacketBufferBC buffer, Side netSide, MessageContext ctx) throws IOException {
        short id = buffer.readUnsignedByte();
        if (netSide == Side.SERVER) {
            if (id != ID_UPDATE_PLUG) throw new InvalidInputDataException("Unknown ID " + ID_ALLOC.getNameFor((int)id));
            if (this.pluggable == null) return;
            this.pluggable.readPayload((PacketBuffer)buffer, netSide, ctx);
            return;
        } else if (id == ID_REMOVE_PLUG) {
            this.holder.eventBus.unregisterHandler(this.pluggable);
            this.pluggable = null;
            return;
        } else if (id == ID_UPDATE_PLUG) {
            this.pluggable.readPayload((PacketBuffer)buffer, netSide, ctx);
            return;
        } else {
            if (id != ID_CREATE_PLUG) throw new InvalidInputDataException("Unknown ID " + ID_ALLOC.getNameFor((int)id));
            this.readCreateInternal((PacketBuffer)buffer);
        }
    }

    public void onTick() {
        if (this.pluggable != null) {
            this.pluggable.onTick();
        }
    }
}

