/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.item;

import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.lib.client.render.font.SpecialColourFontRenderer;
import buildcraft.lib.item.IItemBuildCraft;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.BCTransportBlocks;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPipeHolder
extends ItemBlock
implements IItemBuildCraft,
IItemPipe {
    public final PipeDefinition definition;
    private final String id;
    private String unlocalizedName;
    private CreativeTabs creativeTab;

    protected ItemPipeHolder(PipeDefinition definition, String tagId) {
        super((Block)BCTransportBlocks.pipeHolder);
        this.definition = definition;
        this.id = tagId;
        this.func_77656_e(0);
        this.func_77627_a(true);
        if (!"".equals(this.id)) {
            this.init();
        }
    }

    public static ItemPipeHolder create(PipeDefinition definition) {
        return new ItemPipeHolder(definition, "");
    }

    public static ItemPipeHolder createAndTag(PipeDefinition definition) {
        ResourceLocation reg = definition.identifier;
        String tagId = "item.pipe." + reg.func_110624_b() + "." + reg.func_110623_a();
        return new ItemPipeHolder(definition, tagId);
    }

    public ItemPipeHolder registerWithPipeApi() {
        PipeApi.pipeRegistry.setItemForPipe(this.definition, (IItemPipe)this);
        return this;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
        }
    }

    public String id() {
        return this.id;
    }

    public PipeDefinition getDefinition() {
        return this.definition;
    }

    @SideOnly(value=Side.CLIENT)
    public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        for (int i = 0; i <= 16; ++i) {
            variants.put(i, (Object)new ModelResourceLocation("buildcrafttransport:pipe_item#inventory"));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String colourComponent = "";
        int meta = stack.func_77960_j();
        if (meta > 0 && meta <= 16) {
            EnumDyeColor colour = EnumDyeColor.func_176764_b((int)(meta - 1));
            colourComponent = ColourUtil.getTextFullTooltipSpecial((EnumDyeColor)colour) + " ";
        }
        return colourComponent + super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return SpecialColourFontRenderer.INSTANCE;
    }

    public ItemBlock setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = "item." + unlocalizedName;
        return this;
    }

    public String func_77658_a() {
        return this.unlocalizedName;
    }

    public String func_77667_c(ItemStack stack) {
        return this.unlocalizedName;
    }

    public Item func_77637_a(CreativeTabs tab) {
        this.creativeTab = tab;
        return this;
    }

    public CreativeTabs func_77640_w() {
        return this.creativeTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        String tipName = "tip." + this.unlocalizedName.replace(".name", "").replace("item.", "");
        String localised = I18n.func_135052_a((String)tipName, (Object[])new Object[0]);
        if (!localised.equals(tipName)) {
            tooltip.add(TextFormatting.GRAY + localised);
        }
        if (this.definition.flowType == PipeApi.flowFluids) {
            PipeApi.FluidTransferInfo fti = PipeApi.getFluidTransferInfo((PipeDefinition)this.definition);
            tooltip.add(LocaleUtil.localizeFluidFlow((int)fti.transferPerTick));
        } else if (this.definition.flowType == PipeApi.flowPower) {
            PipeApi.PowerTransferInfo pti = PipeApi.getPowerTransferInfo((PipeDefinition)this.definition);
            tooltip.add(LocaleUtil.localizeMjFlow((long)pti.transferPerTick));
            tooltip.add("Work in progress - the above limit isn't enforced!");
        }
    }
}

