/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.BCModules;
import buildcraft.api.IBuildCraftMod;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApiClient;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.lib.net.MessageManager;
import buildcraft.transport.BCTransportGuis;
import buildcraft.transport.BCTransportModels;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.client.PipeRegistryClient;
import buildcraft.transport.client.render.PipeWireRenderer;
import buildcraft.transport.container.ContainerDiamondPipe;
import buildcraft.transport.container.ContainerDiamondWoodPipe;
import buildcraft.transport.container.ContainerEmzuliPipe_BC8;
import buildcraft.transport.container.ContainerFilteredBuffer_BC8;
import buildcraft.transport.gui.GuiDiamondPipe;
import buildcraft.transport.gui.GuiDiamondWoodPipe;
import buildcraft.transport.gui.GuiEmzuliPipe_BC8;
import buildcraft.transport.gui.GuiFilteredBuffer;
import buildcraft.transport.net.MessageMultiPipeItem;
import buildcraft.transport.pipe.behaviour.PipeBehaviourDiamond;
import buildcraft.transport.pipe.behaviour.PipeBehaviourEmzuli;
import buildcraft.transport.pipe.behaviour.PipeBehaviourWoodDiamond;
import buildcraft.transport.tile.TileFilteredBuffer;
import buildcraft.transport.wire.MessageWireSystems;
import buildcraft.transport.wire.MessageWireSystemsPowered;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BCTransportProxy
implements IGuiHandler {
    @SidedProxy(modId="buildcrafttransport")
    private static BCTransportProxy proxy;

    public static BCTransportProxy getProxy() {
        return proxy;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BCTransportGuis gui = BCTransportGuis.get(id);
        if (gui == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        switch (gui) {
            case FILTERED_BUFFER: {
                if (!(tile instanceof TileFilteredBuffer)) break;
                TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                return new ContainerFilteredBuffer_BC8(player, filteredBuffer);
            }
            case PIPE_DIAMOND: {
                if (!(tile instanceof IPipeHolder)) break;
                IPipeHolder holder = (IPipeHolder)tile;
                IPipe pipe = holder.getPipe();
                if (pipe == null) {
                    return null;
                }
                PipeBehaviour behaviour = pipe.getBehaviour();
                if (!(behaviour instanceof PipeBehaviourDiamond)) break;
                PipeBehaviourDiamond diaPipe = (PipeBehaviourDiamond)behaviour;
                return new ContainerDiamondPipe(player, diaPipe);
            }
            case PIPE_DIAMOND_WOOD: {
                if (!(tile instanceof IPipeHolder)) break;
                IPipeHolder holder = (IPipeHolder)tile;
                IPipe pipe = holder.getPipe();
                if (pipe == null) {
                    return null;
                }
                PipeBehaviour behaviour = pipe.getBehaviour();
                if (!(behaviour instanceof PipeBehaviourWoodDiamond)) break;
                PipeBehaviourWoodDiamond diaPipe = (PipeBehaviourWoodDiamond)behaviour;
                return new ContainerDiamondWoodPipe(player, diaPipe);
            }
            case PIPE_EMZULI: {
                if (!(tile instanceof IPipeHolder)) break;
                IPipeHolder holder = (IPipeHolder)tile;
                IPipe pipe = holder.getPipe();
                if (pipe == null) {
                    return null;
                }
                PipeBehaviour behaviour = pipe.getBehaviour();
                if (!(behaviour instanceof PipeBehaviourEmzuli)) break;
                PipeBehaviourEmzuli emPipe = (PipeBehaviourEmzuli)behaviour;
                return new ContainerEmzuliPipe_BC8(player, emPipe);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void fmlPreInit() {
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.TRANSPORT, MessageWireSystems.class, (Side[])new Side[]{Side.CLIENT});
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.TRANSPORT, MessageWireSystemsPowered.class, (Side[])new Side[]{Side.CLIENT});
        MessageManager.registerMessageClass((IBuildCraftMod)BCModules.TRANSPORT, MessageMultiPipeItem.class, (Side[])new Side[]{Side.CLIENT});
    }

    public void fmlInit() {
    }

    public void fmlPostInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends BCTransportProxy {
        @Override
        public void fmlPreInit() {
            super.fmlPreInit();
            BCTransportSprites.fmlPreInit();
            BCTransportModels.fmlPreInit();
            PipeApiClient.registry = PipeRegistryClient.INSTANCE;
            PipeWireRenderer.init();
            MessageManager.setHandler(MessageWireSystems.class, MessageWireSystems.HANDLER, (Side)Side.CLIENT);
            MessageManager.setHandler(MessageWireSystemsPowered.class, MessageWireSystemsPowered.HANDLER, (Side)Side.CLIENT);
            MessageManager.setHandler(MessageMultiPipeItem.class, MessageMultiPipeItem.HANDLER, (Side)Side.CLIENT);
        }

        @Override
        public void fmlInit() {
            super.fmlInit();
            BCTransportModels.fmlInit();
        }

        @Override
        public void fmlPostInit() {
            super.fmlPostInit();
            BCTransportModels.fmlPostInit();
        }

        @Override
        public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
            BCTransportGuis gui = BCTransportGuis.get(id);
            if (gui == null) {
                return null;
            }
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            switch (gui) {
                case FILTERED_BUFFER: {
                    if (!(tile instanceof TileFilteredBuffer)) break;
                    TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
                    return new GuiFilteredBuffer(new ContainerFilteredBuffer_BC8(player, filteredBuffer));
                }
                case PIPE_DIAMOND: {
                    if (!(tile instanceof IPipeHolder)) break;
                    IPipeHolder holder = (IPipeHolder)tile;
                    IPipe pipe = holder.getPipe();
                    if (pipe == null) {
                        return null;
                    }
                    PipeBehaviour behaviour = pipe.getBehaviour();
                    if (!(behaviour instanceof PipeBehaviourDiamond)) break;
                    PipeBehaviourDiamond diaPipe = (PipeBehaviourDiamond)behaviour;
                    return new GuiDiamondPipe(player, diaPipe);
                }
                case PIPE_DIAMOND_WOOD: {
                    if (!(tile instanceof IPipeHolder)) break;
                    IPipeHolder holder = (IPipeHolder)tile;
                    IPipe pipe = holder.getPipe();
                    if (pipe == null) {
                        return null;
                    }
                    PipeBehaviour behaviour = pipe.getBehaviour();
                    if (!(behaviour instanceof PipeBehaviourWoodDiamond)) break;
                    PipeBehaviourWoodDiamond diaPipe = (PipeBehaviourWoodDiamond)behaviour;
                    return new GuiDiamondWoodPipe(player, diaPipe);
                }
                case PIPE_EMZULI: {
                    if (!(tile instanceof IPipeHolder)) break;
                    IPipeHolder holder = (IPipeHolder)tile;
                    IPipe pipe = holder.getPipe();
                    if (pipe == null) {
                        return null;
                    }
                    PipeBehaviour behaviour = pipe.getBehaviour();
                    if (!(behaviour instanceof PipeBehaviourEmzuli)) break;
                    PipeBehaviourEmzuli emzPipe = (PipeBehaviourEmzuli)behaviour;
                    return new GuiEmzuliPipe_BC8(player, emzPipe);
                }
            }
            return null;
        }
    }

    @SideOnly(value=Side.SERVER)
    public static class ServerProxy
    extends BCTransportProxy {
    }
}

