/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.renderers;

import com.zuxelus.energycontrol.renderers.RotationOffset;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CubeRenderer {
    public static final CubeRenderer MODEL = new CubeRenderer(0.0f, 0.0f, 0.0f, 32, 32, 32, 128.0f, 128.0f, 0, 0, false);
    public static final CubeRenderer DESTROY = new CubeRenderer(0.0f, 0.0f, 0.0f, 32, 32, 32, 32.0f, 32.0f, 0, 0, false);
    public static Map<Long, CubeRenderer> LIBRARY = new HashMap<Long, CubeRenderer>();
    public static Map<Long, CubeRenderer> LIBRARY_FACE = new HashMap<Long, CubeRenderer>();
    private boolean compiled;
    private int displayList;
    private CubeBox cube;

    public CubeRenderer(float offX, float offY, float offZ, int width, int height, int depth, float textureWidth, float textureHeight, int faceOffsetX, int faceOffsetY, boolean faceOnly) {
        this(offX, offY, offZ, width, height, depth, textureWidth, textureHeight, faceOffsetX, faceOffsetY, new RotationOffset(), faceOnly);
    }

    public CubeRenderer(int faceOffsetX, int faceOffsetY, RotationOffset offset, boolean faceOnly) {
        this(0.0f, 0.0f, 0.0f, 32, 32, 32, 128.0f, 128.0f, faceOffsetX, faceOffsetY, offset, faceOnly);
    }

    public CubeRenderer(float x, float y, float z, int dx, int dy, int dz, float textureWidth, float textureHeight, int faceTexU, int faceTexV, RotationOffset offset, boolean faceOnly) {
        this.cube = new CubeBox(x, y, z, dx, dy, dz, textureWidth, textureHeight, faceTexU, faceTexV, offset.leftTop, offset.leftBottom, offset.rightTop, offset.rightBottom, faceOnly);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float scale) {
        if (!this.compiled) {
            this.compileDisplayList(scale);
        }
        GlStateManager.func_179148_o((int)this.displayList);
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        this.cube.render(bufferbuilder, scale);
        GlStateManager.func_187415_K();
        this.compiled = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float scale, long color) {
        if (!this.compiled) {
            this.compileDisplayList(scale, color);
        }
        GlStateManager.func_179148_o((int)this.displayList);
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float scale, long color) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        this.cube.render(bufferbuilder, scale, color);
        GlStateManager.func_187415_K();
        this.compiled = true;
    }

    public static void rotateBlock(EnumFacing facing, EnumFacing rotation) {
        if (rotation == null) {
            rotation = EnumFacing.NORTH;
        }
        switch (facing) {
            case UP: {
                switch (rotation) {
                    case NORTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)-1.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                    }
                }
                break;
            }
            case DOWN: {
                switch (rotation) {
                    case NORTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
                    }
                }
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
            }
        }
    }

    public static void rotateBlockText(EnumFacing facing, EnumFacing rotation) {
        if (rotation == null) {
            rotation = EnumFacing.NORTH;
        }
        switch (facing) {
            case UP: {
                switch (rotation) {
                    case NORTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)-1.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
                    }
                }
                break;
            }
            case DOWN: {
                switch (rotation) {
                    case NORTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)-1.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
                    }
                }
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
            }
        }
    }

    public static CubeRenderer getModel(RotationOffset offset) {
        long hash = (long)(offset.leftTop * 1000000.0f + offset.leftBottom * 10000.0f + offset.rightTop * 100.0f + offset.rightBottom);
        if (LIBRARY.containsKey(hash)) {
            return LIBRARY.get(hash);
        }
        CubeRenderer model = new CubeRenderer(0, 0, offset, false);
        LIBRARY.put(hash, model);
        return model;
    }

    public static CubeRenderer getFaceModel(RotationOffset offset, int textureId) {
        long hash = (long)((float)(textureId * 100000000) + offset.leftTop * 1000000.0f + offset.leftBottom * 10000.0f + offset.rightTop * 100.0f + offset.rightBottom);
        if (LIBRARY_FACE.containsKey(hash)) {
            return LIBRARY_FACE.get(hash);
        }
        CubeRenderer model = new CubeRenderer(textureId / 4 * 32, textureId % 4 * 32, offset, true);
        LIBRARY_FACE.put(hash, model);
        return model;
    }

    private static class CubeBox {
        private final TexturedQuad[] quadList;

        public CubeBox(float x, float y, float z, int dx, int dy, int dz, float textureWidth, float textureHeight, int faceTexU, int faceTexV, float leftTop, float leftBottom, float rightTop, float rightBottom, boolean faceOnly) {
            this.quadList = faceOnly ? new TexturedQuad[1] : new TexturedQuad[6];
            float f = x + (float)dx;
            float f1 = y + (float)dy;
            float f2 = z + (float)dz;
            PositionTextureVertex v7 = new PositionTextureVertex(x, y, z + rightBottom, 0.0f, 0.0f);
            PositionTextureVertex v = new PositionTextureVertex(f, y, z + leftBottom, 0.0f, 8.0f);
            PositionTextureVertex v1 = new PositionTextureVertex(f, f1, z + leftTop, 8.0f, 8.0f);
            PositionTextureVertex v2 = new PositionTextureVertex(x, f1, z + rightTop, 8.0f, 0.0f);
            PositionTextureVertex v3 = new PositionTextureVertex(x, y, f2, 0.0f, 0.0f);
            PositionTextureVertex v4 = new PositionTextureVertex(f, y, f2, 0.0f, 8.0f);
            PositionTextureVertex v5 = new PositionTextureVertex(f, f1, f2, 8.0f, 8.0f);
            PositionTextureVertex v6 = new PositionTextureVertex(x, f1, f2, 8.0f, 0.0f);
            if (faceOnly) {
                this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{v2, v1, v, v7}, faceTexU, faceTexV, faceTexU + dx, faceTexV + dx, textureWidth, textureHeight);
                return;
            }
            this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{v1, v5, v4, v}, 0, dz, dz, dz + dy, textureWidth, textureHeight);
            this.quadList[1] = new TexturedQuad(new PositionTextureVertex[]{v6, v2, v7, v3}, dz + dx, dz, dz + dx + dz, dz + dy, textureWidth, textureHeight);
            this.quadList[2] = new TexturedQuad(new PositionTextureVertex[]{v7, v, v4, v3}, dz, dz + dz, dz + dx, dz + dz + dz, textureWidth, textureHeight);
            this.quadList[3] = new TexturedQuad(new PositionTextureVertex[]{v6, v5, v1, v2}, dz, 0, dz + dx, dz, textureWidth, textureHeight);
            this.quadList[4] = new TexturedQuad(new PositionTextureVertex[]{v2, v1, v, v7}, dz, dz, dz + dx, dz + dy, textureWidth, textureHeight);
            this.quadList[5] = new TexturedQuad(new PositionTextureVertex[]{v5, v6, v3, v4}, dz + dx + dz, dz, dz + dx + dz + dx, dz + dy, textureWidth, textureHeight);
        }

        @SideOnly(value=Side.CLIENT)
        public void render(BufferBuilder renderer, float scale) {
            for (TexturedQuad quad : this.quadList) {
                quad.func_178765_a(renderer, scale);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void render(BufferBuilder renderer, float scale, long color) {
            float c = (float)(color >> 24 & 0xFFL) / 255.0f;
            float c1 = (float)(color >> 16 & 0xFFL) / 255.0f;
            float c2 = (float)(color >> 8 & 0xFFL) / 255.0f;
            float c3 = (float)(color & 0xFFL) / 255.0f;
            for (TexturedQuad quad : this.quadList) {
                Vec3d vec3d = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[0].field_78243_a);
                Vec3d vec3d1 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[2].field_78243_a);
                Vec3d vec3d2 = vec3d1.func_72431_c(vec3d).func_72432_b();
                float f = (float)vec3d2.field_72450_a;
                float f1 = (float)vec3d2.field_72448_b;
                float f2 = (float)vec3d2.field_72449_c;
                renderer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                for (int i = 0; i < 4; ++i) {
                    PositionTextureVertex v = quad.field_78239_a[i];
                    renderer.func_181662_b(v.field_78243_a.field_72450_a * (double)scale, v.field_78243_a.field_72448_b * (double)scale, v.field_78243_a.field_72449_c * (double)scale).func_187315_a((double)v.field_78241_b, (double)v.field_78242_c).func_181666_a(c1, c2, c3, c).func_181663_c(f, f1, f2).func_181675_d();
                }
                Tessellator.func_178181_a().func_78381_a();
            }
        }
    }
}

