/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.kits;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.IItemKit;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.items.kits.ItemKitBase;
import com.zuxelus.energycontrol.items.kits.ItemKitCounter;
import com.zuxelus.energycontrol.items.kits.ItemKitEnergy;
import com.zuxelus.energycontrol.items.kits.ItemKitInventory;
import com.zuxelus.energycontrol.items.kits.ItemKitLiquid;
import com.zuxelus.energycontrol.items.kits.ItemKitLiquidAdvanced;
import com.zuxelus.energycontrol.items.kits.ItemKitRedstone;
import com.zuxelus.energycontrol.items.kits.ItemKitToggle;
import com.zuxelus.energycontrol.items.kits.ItemKitVanilla;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ItemKitMain
extends Item
implements IItemKit {
    private static final Map<Integer, ItemKitBase> KITS = new HashMap<Integer, ItemKitBase>();

    public ItemKitMain() {
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.canRepair = false;
        this.func_77637_a(EnergyControl.creativeTab);
    }

    public final void registerKits() {
        ItemKitMain.register(ItemKitEnergy::new);
        ItemKitMain.register(ItemKitCounter::new);
        ItemKitMain.register(ItemKitLiquid::new);
        ItemKitMain.register(ItemKitLiquidAdvanced::new);
        ItemKitMain.register(ItemKitToggle::new);
        ItemKitMain.register(ItemKitVanilla::new);
        ItemKitMain.register(ItemKitInventory::new);
        ItemKitMain.register(ItemKitRedstone::new);
    }

    public static void register(Supplier<ItemKitBase> factory) {
        ItemKitBase item = factory.get();
        if (ItemKitMain.checkKit(item)) {
            KITS.put(item.getDamage(), item);
        }
    }

    private static boolean checkKit(ItemKitBase item) {
        if (!KITS.containsKey(item.getDamage())) {
            return true;
        }
        if (item.getDamage() <= 49) {
            EnergyControl.logger.warn(String.format("Kit %s was not registered. ID %d is already used for standard kit.", item.getUnlocalizedName(), item.getDamage()));
        } else {
            EnergyControl.logger.warn(String.format("Kit %s was not registered. ID %d is already used for extended kit.", item.getUnlocalizedName(), item.getDamage()));
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (KITS.containsKey(damage)) {
            return KITS.get(damage).getUnlocalizedName();
        }
        return "";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Map.Entry<Integer, ItemKitBase> entry : KITS.entrySet()) {
            Integer key = entry.getKey();
            items.add((Object)new ItemStack((Item)this, 1, key.intValue()));
        }
    }

    @Override
    public ItemStack getSensorCard(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        int damage = stack.func_77952_i();
        if (KITS.containsKey(damage)) {
            return KITS.get(damage).getSensorCard(stack, player, world, pos, side);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_77645_m() {
        return true;
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack card;
        Item item;
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if (!player.field_70170_p.field_72995_K && !stack.func_190926_b() && (item = stack.func_77973_b()) instanceof IItemKit && !(card = ((IItemKit)item).getSensorCard(stack, player, player.field_70170_p, event.getPos(), event.getFace())).func_190926_b()) {
            stack.func_190918_g(1);
            EntityItem dropItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, card);
            dropItem.func_174867_a(0);
            player.field_70170_p.func_72838_d((Entity)dropItem);
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    public static void registerModels() {
        for (Map.Entry<Integer, ItemKitBase> entry : KITS.entrySet()) {
            Integer key = entry.getKey();
            if (key > 49) continue;
            ModItems.registerItemModel(ModItems.itemKit, key, KITS.get(key).getName());
        }
    }

    public static void registerExtendedModels() {
        for (Map.Entry<Integer, ItemKitBase> entry : KITS.entrySet()) {
            Integer key = entry.getKey();
            if (key <= 49) continue;
            ModItems.registerExternalItemModel(ModItems.itemKit, key, KITS.get(key).getName());
        }
    }
}

