/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardNuclearCraft
extends ItemCardBase {
    private static DecimalFormat df = new DecimalFormat("0.0");

    public ItemCardNuclearCraft() {
        super(26, "card_nuclearcraft");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        NBTTagCompound tag = CrossModLoader.getCrossMod("nuclearcraft").getCardData(world, target);
        if (tag == null) {
            return CardState.NO_TARGET;
        }
        reader.reset();
        reader.copyFrom(tag);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if (!reader.hasField("type")) {
            return result;
        }
        int type = reader.getInt("type");
        switch (type) {
            case 1: {
                result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getInt("energy").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getInt("capacity").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getInt("output").intValue(), "RF/t", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelRadiation", reader.getDouble("radiation"), showLabels));
                break;
            }
            case 2: {
                result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getInt("energy").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getInt("capacity").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelProcessPowerRF", reader.getInt("power").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelSpeedMultiplierRF", reader.getDouble("speedM"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelPowerMultiplierRF", reader.getDouble("powerM"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelProcessTime", reader.getInt("time").intValue(), showLabels));
                break;
            }
            case 3: {
                result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getInt("energy").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getInt("capacity").intValue(), "RF", showLabels));
                break;
            }
            case 4: {
                result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getInt("energy").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getInt("capacity").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelOutput", reader.getInt("output").intValue(), "RF/t", showLabels));
                break;
            }
            case 5: {
                result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getInt("energy").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getInt("capacity").intValue(), "RF", showLabels));
                break;
            }
            case 6: {
                this.addHeat(result, "msg.ec.InfoPanelTemp", (int)Math.round(reader.getDouble("heat")), reader.getInt("maxHeat"), showLabels);
                result.add(new PanelString("msg.ec.InfoPanelHeatChange", reader.getDouble("heatChange"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getString("size"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelFuel", reader.getString("fuel"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelProcessPowerRF", reader.getDouble("power"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelEnergy", reader.getInt("energy").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCapacity", reader.getInt("capacity").intValue(), "RF", showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCoolingRate", reader.getDouble("cooling"), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelCells", reader.getInt("cells").intValue(), showLabels));
                this.addOnOff(result, isServer, reader.getBoolean("active"));
                break;
            }
            case 7: {
                if (!reader.getString("gasTankName").equals("")) {
                    result.add(new PanelString(I18n.func_135052_a((String)reader.getString("gasTankName"), (Object[])new Object[0]) + ": " + reader.getString("gasTank")));
                }
                result.add(new PanelString("msg.ec.InfoPanelAtmosphericValve", reader.getInt("valve").intValue(), showLabels));
                if (!reader.getString("liquidTankName").equals("")) {
                    result.add(new PanelString(I18n.func_135052_a((String)reader.getString("liquidTankName"), (Object[])new Object[0]) + ": " + reader.getString("liquidTank")));
                }
                if (reader.getString("liquidTank2Name").equals("")) break;
                result.add(new PanelString(I18n.func_135052_a((String)reader.getString("liquidTank2Name"), (Object[])new Object[0]) + ": " + reader.getString("liquidTank2")));
                break;
            }
            case 8: {
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getString("size"), showLabels));
                result.add(new PanelString("msg.nc.NumberOfClusters", reader.getInt("clusterCount").intValue(), showLabels));
                result.add(new PanelString("msg.nc.MeanEfficiency", reader.getDouble("meanEfficiency"), showLabels));
                result.add(new PanelString("msg.nc.ProductionRate", reader.getDouble("outputRate"), "mB/t", showLabels));
                result.add(new PanelString("msg.nc.SparsityEfficiencyMult", reader.getDouble("sparsityEfficiencyMult"), showLabels));
                result.add(new PanelString("msg.nc.CasingTemp", reader.getInt("temp").intValue(), "K", showLabels));
                result.add(new PanelString("msg.nc.NetClusterHeating", reader.getLong("heat").longValue(), "H/t", showLabels));
                result.add(new PanelString("msg.nc.CasingHeatLevel", reader.getString("level"), showLabels));
                result.add(new PanelString("msg.nc.TotalClusterCooling", reader.getLong("cooling").longValue(), "H/t", showLabels));
                this.addOnOff(result, isServer, reader.getBoolean("active"));
                break;
            }
            case 9: {
                result.add(new PanelString("msg.ec.InfoPanelSize", reader.getString("size"), showLabels));
                result.add(new PanelString("msg.nc.NumberOfClusters", reader.getInt("clusterCount").intValue(), showLabels));
                result.add(new PanelString("msg.nc.MeanEfficiency", reader.getDouble("meanEfficiency"), showLabels));
                result.add(new PanelString("msg.nc.SparsityEfficiencyMult", reader.getDouble("sparsityEfficiencyMult"), showLabels));
                result.add(new PanelString("msg.nc.CasingTemp", reader.getInt("temp").intValue(), "K", showLabels));
                result.add(new PanelString("msg.nc.NetClusterHeating", reader.getLong("heat").longValue(), "H/t", showLabels));
                result.add(new PanelString("msg.nc.CasingHeatLevel", reader.getString("level"), showLabels));
                result.add(new PanelString("msg.nc.TotalClusterCooling", reader.getLong("cooling").longValue(), "H/t", showLabels));
                this.addOnOff(result, isServer, reader.getBoolean("active"));
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(2);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStatus", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 2));
        return result;
    }
}

