/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossMekanism;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardMekanism;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import com.zuxelus.energycontrol.items.kits.ItemKitMekanism;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.List;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.FusionReactor;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorFrame;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.IFluidTank;

public class CrossMekanismGenerators
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        String euType = CrossMekanism.getEUType();
        if (te instanceof TileEntityTurbineCasing) {
            SynchronizedTurbineData turbine = (SynchronizedTurbineData)((TileEntityTurbineCasing)te).structure;
            if (turbine == null) {
                return null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", euType);
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)turbine.electricityStored));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)turbine.getEnergyCapacity()));
            return tag;
        }
        if (te instanceof TileEntityReactorFrame) {
            FusionReactor reactor = ((TileEntityReactorFrame)te).fusionReactor;
            if (reactor == null) {
                return null;
            }
            TileEntityReactorController controller = reactor.controller;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", euType);
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)controller.electricityStored));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)controller.maxEnergy));
            return tag;
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        if (te instanceof TileEntityHeatGenerator) {
            result.add(new FluidInfo((IFluidTank)((TileEntityHeatGenerator)te).lavaTank));
            return result;
        }
        if (te instanceof TileEntityGasGenerator) {
            result.add(CrossMekanism.toFluidInfo(((TileEntityGasGenerator)te).fuelTank));
            return result;
        }
        if (te instanceof TileEntityTurbineCasing) {
            SynchronizedTurbineData turbine = (SynchronizedTurbineData)((TileEntityTurbineCasing)te).structure;
            if (turbine == null) {
                return null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            result.add(new FluidInfo(turbine.fluidStored, turbine.getFluidCapacity()));
            return result;
        }
        if (te instanceof TileEntityReactorFrame) {
            FusionReactor reactor = ((TileEntityReactorFrame)te).fusionReactor;
            if (reactor == null) {
                return null;
            }
            TileEntityReactorController controller = reactor.controller;
            result.add(CrossMekanism.toFluidInfo(controller.deuteriumTank));
            result.add(CrossMekanism.toFluidInfo(controller.tritiumTank));
            result.add(CrossMekanism.toFluidInfo(controller.fuelTank));
            result.add(new FluidInfo((IFluidTank)controller.waterTank));
            result.add(new FluidInfo((IFluidTank)controller.steamTank));
            return result;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGenerator) {
            double production;
            NBTTagCompound tag = CrossMekanism.setStorage(te);
            if (te instanceof TileEntityHeatGenerator) {
                production = MekanismUtils.convertToDisplay((double)((TileEntityHeatGenerator)te).producingEnergy);
                tag.func_74780_a("output", production);
                tag.func_74757_a("active", production > 0.0);
                tag.func_74778_a("temp", CrossMekanism.getTempString(((TileEntityHeatGenerator)te).temperature));
                FluidInfo.addTank("tank", tag, ((TileEntityHeatGenerator)te).lavaTank);
            }
            if (te instanceof TileEntityWindGenerator) {
                production = MekanismUtils.convertToDisplay((double)(MekanismConfig.current().generators.windGenerationMin.val() * (double)((TileEntityWindGenerator)te).getMultiplier()));
                tag.func_74780_a("output", production);
                tag.func_74757_a("active", production > 0.0);
            }
            if (te instanceof TileEntitySolarGenerator) {
                production = MekanismUtils.convertToDisplay((double)((TileEntitySolarGenerator)te).getProduction());
                tag.func_74780_a("output", production);
                tag.func_74757_a("active", production > 0.0);
            }
            if (te instanceof TileEntityGasGenerator) {
                if (((TileEntityGasGenerator)te).getActive()) {
                    tag.func_74780_a("output", MekanismUtils.convertToDisplay((double)(((TileEntityGasGenerator)te).generationRate * (double)((TileEntityGasGenerator)te).clientUsed)));
                    tag.func_74757_a("active", true);
                } else {
                    tag.func_74780_a("output", 0.0);
                    tag.func_74757_a("active", false);
                }
                CrossMekanism.addTank("tank", tag, ((TileEntityGasGenerator)te).fuelTank);
            }
            if (te instanceof TileEntityBioGenerator) {
                if (((TileEntityBioGenerator)te).getActive()) {
                    tag.func_74780_a("output", MekanismUtils.convertToDisplay((double)MekanismConfig.current().generators.bioGeneration.val()));
                    tag.func_74757_a("active", true);
                } else {
                    tag.func_74780_a("output", 0.0);
                    tag.func_74757_a("active", false);
                }
                CrossMekanism.addTank("tank", tag, ((TileEntityBioGenerator)te).bioFuelSlot, "bioethanol");
            }
            return tag;
        }
        if (te instanceof TileEntityTurbineCasing) {
            SynchronizedTurbineData turbine = (SynchronizedTurbineData)((TileEntityTurbineCasing)te).structure;
            if (turbine == null) {
                return null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", CrossMekanism.getEUType());
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)turbine.electricityStored));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)turbine.getEnergyCapacity()));
            double energyMultiplier = MekanismConfig.current().general.maxEnergyPerSteam.val() / 28.0 * (double)Math.min(turbine.blades, turbine.coils * MekanismConfig.current().generators.turbineBladesPerCoil.val());
            double rate = (double)(turbine.lowerVolume * turbine.getDispersers()) * MekanismConfig.current().generators.turbineDisperserGasFlow.val();
            tag.func_74780_a("output", MekanismUtils.convertToDisplay((double)((double)turbine.clientFlow * energyMultiplier)));
            tag.func_74780_a("flow_rate", (double)turbine.clientFlow);
            tag.func_74780_a("max_flow_rate", Math.min(rate, (double)turbine.vents * MekanismConfig.current().generators.turbineVentGasFlow.val()));
            tag.func_74757_a("active", turbine.clientRotation > 0.0f);
            FluidInfo.addTank("tank", tag, turbine.fluidStored);
            return tag;
        }
        if (te instanceof TileEntityReactorFrame) {
            FusionReactor reactor = ((TileEntityReactorFrame)te).fusionReactor;
            if (reactor == null) {
                return null;
            }
            TileEntityReactorController controller = reactor.controller;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", CrossMekanism.getEUType());
            tag.func_74780_a("energy", MekanismUtils.convertToDisplay((double)controller.electricityStored));
            tag.func_74780_a("capacity", MekanismUtils.convertToDisplay((double)controller.maxEnergy));
            tag.func_74780_a("output", MekanismUtils.convertToDisplay((double)reactor.getPassiveGeneration(false, true)));
            tag.func_74778_a("temp", CrossMekanism.getTempString(reactor.lastCaseTemperature));
            tag.func_74778_a("plasma", CrossMekanism.getTempString(reactor.plasmaTemperature));
            tag.func_74780_a("injection_rate", (double)reactor.injectionRate);
            CrossMekanism.addTank("tank", tag, controller.deuteriumTank);
            CrossMekanism.addTank("tank2", tag, controller.tritiumTank);
            CrossMekanism.addTank("tank3", tag, controller.fuelTank);
            FluidInfo.addTank("tank4", tag, controller.waterTank);
            FluidInfo.addTank("tank5", tag, controller.steamTank);
            return tag;
        }
        return null;
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemKitMain.register(ItemKitMekanism::new);
        ItemCardMain.register(ItemCardMekanism::new);
    }
}

