/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.OreHelper;
import com.zuxelus.energycontrol.blocks.AFSU;
import com.zuxelus.energycontrol.blocks.SeedAnalyzer;
import com.zuxelus.energycontrol.blocks.SeedLibrary;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.crossmod.IC2ReactorHelper;
import com.zuxelus.energycontrol.hooks.IC2Hooks;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.items.ItemAFB;
import com.zuxelus.energycontrol.items.ItemAFSU;
import com.zuxelus.energycontrol.items.ItemAFSUUpgradeKit;
import com.zuxelus.energycontrol.items.ItemDigitalThermometer;
import com.zuxelus.energycontrol.items.cards.ItemCardIC2;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.kits.ItemKitIC2;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import com.zuxelus.energycontrol.tileentities.TileEntityAFSU;
import com.zuxelus.energycontrol.tileentities.TileEntitySeedAnalyzer;
import com.zuxelus.energycontrol.tileentities.TileEntitySeedLibrary;
import com.zuxelus.energycontrol.utils.DataHelper;
import com.zuxelus.energycontrol.utils.FluidInfo;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.api.item.ICustomDamageItem;
import ic2.api.item.IElectricItem;
import ic2.api.reactor.IReactor;
import ic2.api.tile.IEnergyStorage;
import ic2.core.WorldData;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityHeatSourceInventory;
import ic2.core.block.comp.Energy;
import ic2.core.block.comp.Fluids;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.generator.tileentity.TileEntityConversionGenerator;
import ic2.core.block.generator.tileentity.TileEntityGenerator;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntityKineticGenerator;
import ic2.core.block.generator.tileentity.TileEntityRTGenerator;
import ic2.core.block.generator.tileentity.TileEntitySemifluidGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.block.generator.tileentity.TileEntityStirlingGenerator;
import ic2.core.block.generator.tileentity.TileEntityWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityWindGenerator;
import ic2.core.block.heatgenerator.tileentity.TileEntityElectricHeatGenerator;
import ic2.core.block.heatgenerator.tileentity.TileEntityFluidHeatGenerator;
import ic2.core.block.heatgenerator.tileentity.TileEntityRTHeatGenerator;
import ic2.core.block.heatgenerator.tileentity.TileEntitySolidHeatGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityElectricKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityManualKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntitySteamKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityStirlingKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityWaterKineticGenerator;
import ic2.core.block.kineticgenerator.tileentity.TileEntityWindKineticGenerator;
import ic2.core.block.machine.tileentity.TileEntityCondenser;
import ic2.core.block.machine.tileentity.TileEntityFluidRegulator;
import ic2.core.block.machine.tileentity.TileEntityLiquidHeatExchanger;
import ic2.core.block.machine.tileentity.TileEntitySteamGenerator;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorChamberElectric;
import ic2.core.block.reactor.tileentity.TileEntityReactorVessel;
import ic2.core.block.state.IIdProvider;
import ic2.core.block.type.ResourceBlock;
import ic2.core.init.MainConfig;
import ic2.core.item.reactor.ItemReactorLithiumCell;
import ic2.core.item.reactor.ItemReactorUranium;
import ic2.core.item.tool.ItemToolWrench;
import ic2.core.profile.ProfileManager;
import ic2.core.profile.Version;
import ic2.core.ref.BlockName;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CrossIC2Exp
extends CrossModBase {
    @Override
    public ItemStack getItemStack(String name) {
        switch (name) {
            case "transformer": {
                return IC2Items.getItem((String)"upgrade", (String)"transformer");
            }
            case "energy_storage": {
                return IC2Items.getItem((String)"upgrade", (String)"energy_storage");
            }
            case "mfsu": {
                return IC2Items.getItem((String)"te", (String)"mfsu");
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getChargedStack(ItemStack stack) {
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        return stack;
    }

    @Override
    public boolean isWrench(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemToolWrench;
    }

    @Override
    public boolean isElectricItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IElectricItem;
    }

    @Override
    public double dischargeItem(ItemStack stack, double needed, int tier) {
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        if (item.canProvideEnergy(stack)) {
            return ElectricItem.manager.discharge(stack, needed, tier, false, false, false);
        }
        return 0.0;
    }

    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("euType", "EU");
        if (te instanceof IEnergyStorage) {
            tag.func_74780_a("energy", (double)((IEnergyStorage)te).getStored());
            tag.func_74780_a("capacity", (double)((IEnergyStorage)te).getCapacity());
            return tag;
        }
        if (te instanceof TileEntityBaseGenerator) {
            Energy energy = (Energy)((TileEntityBaseGenerator)te).getComponent(Energy.class);
            tag.func_74780_a("energy", energy.getEnergy());
            tag.func_74780_a("capacity", energy.getCapacity());
            return tag;
        }
        if (te instanceof TileEntitySemifluidGenerator) {
            Energy energy = (Energy)((TileEntitySemifluidGenerator)te).getComponent(Energy.class);
            tag.func_74780_a("energy", energy.getEnergy());
            tag.func_74780_a("capacity", energy.getCapacity());
            return tag;
        }
        if (te instanceof TileEntityStirlingGenerator) {
            Energy energy = (Energy)((TileEntityStirlingGenerator)te).getComponent(Energy.class);
            tag.func_74780_a("energy", energy.getEnergy());
            tag.func_74780_a("capacity", energy.getCapacity());
            return tag;
        }
        if (te instanceof TileEntityGeoGenerator) {
            Energy energy = (Energy)((TileEntityGeoGenerator)te).getComponent(Energy.class);
            tag.func_74780_a("energy", energy.getEnergy());
            tag.func_74780_a("capacity", energy.getCapacity());
            return tag;
        }
        if (te instanceof TileEntityElectricKineticGenerator) {
            Energy energy = (Energy)((TileEntityElectricKineticGenerator)te).getComponent(Energy.class);
            tag.func_74780_a("energy", energy.getEnergy());
            tag.func_74780_a("capacity", energy.getCapacity());
            return tag;
        }
        if (te instanceof TileEntityElectricHeatGenerator) {
            Energy energy = (Energy)((TileEntityElectricHeatGenerator)te).getComponent(Energy.class);
            tag.func_74780_a("energy", energy.getEnergy());
            tag.func_74780_a("capacity", energy.getCapacity());
            return tag;
        }
        if (te instanceof TileEntityCondenser) {
            Energy energy = (Energy)((TileEntityCondenser)te).getComponent(Energy.class);
            tag.func_74780_a("energy", energy.getEnergy());
            tag.func_74780_a("capacity", energy.getCapacity());
            return tag;
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (!(te instanceof TileEntityBlock)) {
            return null;
        }
        if (!((TileEntityBlock)te).hasComponent(Fluids.class)) {
            return null;
        }
        Fluids fluid = (Fluids)((TileEntityBlock)te).getComponent(Fluids.class);
        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
        for (FluidTank tank : fluid.getAllTanks()) {
            result.add(new FluidInfo((IFluidTank)tank));
        }
        return result;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        try {
            TileEntityElectricKineticGenerator generator;
            Energy energy;
            NBTTagCompound tag = new NBTTagCompound();
            if (te instanceof IEnergyStorage) {
                tag.func_74780_a("energy", (double)((IEnergyStorage)te).getStored());
                tag.func_74780_a("capacity", (double)((IEnergyStorage)te).getCapacity());
                ArrayList values = this.getHookValues(te);
                if (values != null) {
                    tag.func_74780_a("diff", ((Double)values.get(0) - (Double)values.get(20)) / 20.0);
                }
                return tag;
            }
            if (te instanceof TileEntityBaseGenerator) {
                energy = (Energy)((TileEntityBaseGenerator)te).getComponent(Energy.class);
                tag.func_74780_a("energy", energy.getEnergy());
                tag.func_74780_a("capacity", energy.getCapacity());
                if (te instanceof TileEntityGenerator) {
                    tag.func_74780_a("output", this.isActive(te) ? DataHelper.getDouble(TileEntityBaseGenerator.class, "production", te) : 0.0);
                    return tag;
                }
                if (te instanceof TileEntityRTGenerator) {
                    int counter = 0;
                    for (int i = 0; i < ((TileEntityRTGenerator)te).fuelSlot.size(); ++i) {
                        if (((TileEntityRTGenerator)te).fuelSlot.isEmpty(i)) continue;
                        ++counter;
                    }
                    tag.func_74768_a("pellets", counter);
                    if (counter == 0 || energy.getEnergy() >= energy.getCapacity()) {
                        tag.func_74757_a("active", false);
                        tag.func_74780_a("output", 0.0);
                        return tag;
                    }
                    tag.func_74757_a("active", true);
                    double efficiency = DataHelper.getFloat(TileEntityRTGenerator.class, "efficiency", te);
                    tag.func_74780_a("multiplier", efficiency);
                    tag.func_74780_a("output", Math.pow(2.0, counter - 1) * efficiency);
                    return tag;
                }
                if (te instanceof TileEntitySolarGenerator) {
                    double multiplier = DataHelper.getDouble(TileEntitySolarGenerator.class, "energyMultiplier", te);
                    boolean active = ((TileEntitySolarGenerator)te).skyLight > 0.0f && energy.getEnergy() < energy.getCapacity();
                    tag.func_74780_a("multiplier", multiplier);
                    tag.func_74757_a("active", active);
                    tag.func_74780_a("output", active ? multiplier * (double)((TileEntitySolarGenerator)te).skyLight : 0.0);
                    return tag;
                }
                if (te instanceof TileEntityWaterGenerator) {
                    boolean active = ((TileEntityWaterGenerator)te).water > 0 || ((TileEntityWaterGenerator)te).fuel > 0;
                    double multiplier = DataHelper.getDouble(TileEntityWaterGenerator.class, "energyMultiplier", te);
                    tag.func_74780_a("multiplier", multiplier);
                    tag.func_74757_a("active", active);
                    if (((TileEntityWaterGenerator)te).fuel <= 0) {
                        tag.func_74780_a("output", multiplier * (double)((TileEntityWaterGenerator)te).water / 100.0);
                    } else {
                        tag.func_74780_a("output", DataHelper.getDouble(TileEntityBaseGenerator.class, "production", te));
                    }
                    return tag;
                }
                if (te instanceof TileEntityWindGenerator) {
                    double production = DataHelper.getDouble(TileEntityBaseGenerator.class, "production", te);
                    boolean active = production > 0.0 && energy.getEnergy() < 4.0;
                    double multiplier = DataHelper.getDouble(TileEntityWindGenerator.class, "energyMultiplier", te);
                    tag.func_74780_a("multiplier", multiplier * 0.1);
                    tag.func_74757_a("active", active);
                    tag.func_74780_a("output", active ? production : 0.0);
                    int obstructedBlocks = DataHelper.getInt(TileEntityWindGenerator.class, "obstructedBlockCount", te);
                    tag.func_74768_a("height", te.func_174877_v().func_177956_o());
                    tag.func_74768_a("obstructedBlocks", obstructedBlocks);
                    tag.func_74780_a("wind", WorldData.get((World)te.func_145831_w()).windSim.getWindAt((double)te.func_174877_v().func_177956_o()) * (1.0 - (double)obstructedBlocks / 567.0));
                    return tag;
                }
            }
            if (te instanceof TileEntitySemifluidGenerator) {
                energy = (Energy)((TileEntitySemifluidGenerator)te).getComponent(Energy.class);
                tag.func_74780_a("energy", energy.getEnergy());
                tag.func_74780_a("capacity", energy.getCapacity());
                tag.func_74780_a("output", ((TileEntitySemifluidGenerator)te).isConverting() ? DataHelper.getDouble(TileEntityBaseGenerator.class, "production", te) : 0.0);
                tag.func_74757_a("active", ((TileEntitySemifluidGenerator)te).isConverting());
                Fluids fluids = (Fluids)((TileEntitySemifluidGenerator)te).getComponent(Fluids.class);
                FluidInfo.addTank("tank", tag, fluids.getFluidTank("fluid"));
                return tag;
            }
            if (te instanceof TileEntityStirlingGenerator) {
                double production = DataHelper.getDouble(TileEntityConversionGenerator.class, "lastProduction", te);
                tag.func_74757_a("active", production > 0.0);
                tag.func_74780_a("output", production);
                tag.func_74780_a("multiplier", DataHelper.getDouble(TileEntityStirlingGenerator.class, "productionpeerheat", te));
                return tag;
            }
            if (te instanceof TileEntityGeoGenerator) {
                energy = (Energy)((TileEntityGeoGenerator)te).getComponent(Energy.class);
                tag.func_74780_a("energy", energy.getEnergy());
                tag.func_74780_a("capacity", energy.getCapacity());
                boolean active = ((TileEntityGeoGenerator)te).getActive();
                tag.func_74757_a("active", active);
                tag.func_74780_a("output", active ? DataHelper.getDouble(TileEntityBaseGenerator.class, "production", te) : 0.0);
                Fluids fluids = (Fluids)((TileEntityGeoGenerator)te).getComponent(Fluids.class);
                FluidInfo.addTank("tank", tag, fluids.getFluidTank("fluid"));
                return tag;
            }
            if (te instanceof TileEntityKineticGenerator) {
                boolean active = ((TileEntityKineticGenerator)te).getActive();
                tag.func_74757_a("active", active);
                tag.func_74780_a("output", DataHelper.getDouble(TileEntityConversionGenerator.class, "lastProduction", te));
                tag.func_74780_a("multiplier", DataHelper.getDouble(TileEntityKineticGenerator.class, "euPerKu", te));
                return tag;
            }
            if (te instanceof TileEntityElectricKineticGenerator) {
                generator = (TileEntityElectricKineticGenerator)te;
                int counter = 0;
                for (int i = 0; i < generator.slotMotor.size(); ++i) {
                    if (generator.slotMotor.get(i).func_190926_b()) continue;
                    ++counter;
                }
                tag.func_74768_a("motors", counter);
                Energy energy2 = (Energy)generator.getComponent(Energy.class);
                tag.func_74780_a("energy", energy2.getEnergy());
                tag.func_74780_a("capacity", energy2.getCapacity());
                tag.func_74757_a("active", energy2.getEnergy() > 0.0 && counter > 0);
                tag.func_74780_a("energyKU", generator.ku);
                generator.getClass();
                tag.func_74780_a("capacityKU", 1000.0);
                ArrayList values = this.getHookValues(te);
                if (values != null) {
                    tag.func_74780_a("outputKU", ((Double)values.get(0)).doubleValue());
                }
                tag.func_74780_a("multiplier", (double)DataHelper.getFloat(TileEntityElectricKineticGenerator.class, "kuPerEU", te));
                return tag;
            }
            if (te instanceof TileEntityManualKineticGenerator) {
                tag.func_74780_a("energy", (double)((TileEntityManualKineticGenerator)te).currentKU);
                ((TileEntityManualKineticGenerator)te).getClass();
                tag.func_74780_a("capacity", 1000.0);
                return tag;
            }
            if (te instanceof TileEntitySteamKineticGenerator) {
                tag.func_74757_a("active", ((TileEntityBlock)te).getActive());
                tag.func_74780_a("outputKU", (double)((TileEntitySteamKineticGenerator)te).getKUoutput());
                Field field = TileEntitySteamKineticGenerator.class.getDeclaredField("steamTank");
                field.setAccessible(true);
                FluidInfo.addTank("tank", tag, (FluidTank)field.get(te));
                return tag;
            }
            if (te instanceof TileEntityStirlingKineticGenerator) {
                tag.func_74757_a("active", ((TileEntityBlock)te).getActive());
                tag.func_74780_a("energyKU", (double)DataHelper.getInt(TileEntityStirlingKineticGenerator.class, "kUBuffer", te));
                tag.func_74780_a("capacityKU", (double)DataHelper.getInt(TileEntityStirlingKineticGenerator.class, "maxkUBuffer", te));
                tag.func_74780_a("energyHU", (double)DataHelper.getInt(TileEntityStirlingKineticGenerator.class, "heatbuffer", te));
                tag.func_74780_a("capacityHU", (double)DataHelper.getInt(TileEntityStirlingKineticGenerator.class, "maxHeatbuffer", te));
                tag.func_74780_a("multiplier", 3.0);
                return tag;
            }
            if (te instanceof TileEntityWaterKineticGenerator) {
                generator = (TileEntityWaterKineticGenerator)te;
                tag.func_74780_a("outputKU", (double)generator.getKuOutput());
                tag.func_74780_a("waterFlow", (double)DataHelper.getInt(TileEntityWaterKineticGenerator.class, "waterFlow", te));
                tag.func_74780_a("multiplier", (double)DataHelper.getFloat(TileEntityWaterKineticGenerator.class, "outputModifier", te));
                tag.func_74768_a("height", generator.func_174877_v().func_177956_o());
                if (generator.rotorSlot.isEmpty()) {
                    tag.func_74780_a("health", -1.0);
                } else {
                    tag.func_74780_a("health", (double)(100.0f - (float)generator.rotorSlot.get().func_77952_i() * 100.0f / (float)generator.rotorSlot.get().func_77958_k()));
                }
                return tag;
            }
            if (te instanceof TileEntityWindKineticGenerator) {
                generator = (TileEntityWindKineticGenerator)te;
                tag.func_74780_a("outputKU", (double)generator.getKuOutput());
                tag.func_74780_a("wind", DataHelper.getDouble(TileEntityWindKineticGenerator.class, "windStrength", te));
                tag.func_74780_a("multiplier", (double)(generator.getEfficiency() * TileEntityWindKineticGenerator.outputModifier));
                tag.func_74768_a("height", generator.func_174877_v().func_177956_o());
                if (generator.rotorSlot.isEmpty()) {
                    tag.func_74780_a("health", -1.0);
                } else {
                    tag.func_74780_a("health", (double)(100.0f - (float)generator.rotorSlot.get().func_77952_i() * 100.0f / (float)generator.rotorSlot.get().func_77958_k()));
                }
                return tag;
            }
            if (te instanceof TileEntityHeatSourceInventory) {
                int buffer = ((TileEntityHeatSourceInventory)te).getHeatBuffer();
                tag.func_74768_a("energyHU", buffer);
                if (te instanceof TileEntityElectricHeatGenerator) {
                    Energy energy3 = (Energy)((TileEntityElectricHeatGenerator)te).getComponent(Energy.class);
                    tag.func_74780_a("energy", energy3.getEnergy());
                    tag.func_74780_a("capacity", energy3.getCapacity());
                    int counter = 0;
                    for (int i = 0; i < ((TileEntityElectricHeatGenerator)te).coilSlot.size(); ++i) {
                        if (((TileEntityElectricHeatGenerator)te).coilSlot.get(i).func_190926_b()) continue;
                        ++counter;
                    }
                    tag.func_74768_a("coils", counter);
                    boolean active = ((TileEntityHeatSourceInventory)te).getActive();
                    tag.func_74757_a("active", active);
                    tag.func_74768_a("outputHU", active ? ((TileEntityHeatSourceInventory)te).gettransmitHeat() : 0);
                    tag.func_74780_a("multiplier", DataHelper.getDouble(TileEntityElectricHeatGenerator.class, "outputMultiplier", te));
                    return tag;
                }
                if (te instanceof TileEntityFluidHeatGenerator) {
                    boolean active = DataHelper.getInt(TileEntityFluidHeatGenerator.class, "production", te) > 0;
                    tag.func_74757_a("active", active);
                    tag.func_74768_a("outputHU", active ? ((TileEntityHeatSourceInventory)te).gettransmitHeat() : 0);
                    FluidInfo.addTank("tank", tag, ((TileEntityFluidHeatGenerator)te).getFluidTank());
                    return tag;
                }
                if (te instanceof TileEntityLiquidHeatExchanger) {
                    FluidInfo.addTank("tank", tag, ((TileEntityLiquidHeatExchanger)te).inputTank);
                    FluidInfo.addTank("tank2", tag, ((TileEntityLiquidHeatExchanger)te).outputTank);
                    int counter = 0;
                    for (int i = 0; i < ((TileEntityLiquidHeatExchanger)te).heatexchangerslots.size(); ++i) {
                        if (((TileEntityLiquidHeatExchanger)te).heatexchangerslots.get(i) == null) continue;
                        ++counter;
                    }
                    boolean active = buffer == 0;
                    tag.func_74757_a("active", active);
                    tag.func_74768_a("outputHU", active ? ((TileEntityHeatSourceInventory)te).gettransmitHeat() : 0);
                    tag.func_74768_a("conductors", counter);
                    return tag;
                }
                if (te instanceof TileEntityRTHeatGenerator) {
                    int counter = 0;
                    for (int i = 0; i < ((TileEntityRTHeatGenerator)te).fuelSlot.size(); ++i) {
                        if (((TileEntityRTHeatGenerator)te).fuelSlot.get(i).func_190926_b()) continue;
                        ++counter;
                    }
                    tag.func_74768_a("pellets", counter);
                    boolean active = counter > 0;
                    tag.func_74757_a("active", active);
                    tag.func_74768_a("outputHU", active ? ((TileEntityHeatSourceInventory)te).gettransmitHeat() : 0);
                    tag.func_74780_a("multiplier", (double)TileEntityRTHeatGenerator.outputMultiplier);
                    return tag;
                }
                if (te instanceof TileEntitySolidHeatGenerator) {
                    boolean active = ((TileEntityBlock)te).getActive();
                    tag.func_74757_a("active", active);
                    tag.func_74768_a("outputHU", active ? ((TileEntityHeatSourceInventory)te).gettransmitHeat() : 0);
                    tag.func_74768_a("energy", DataHelper.getInt(TileEntitySolidHeatGenerator.class, "heatbuffer", te) + ((TileEntitySolidHeatGenerator)te).getHeatBuffer());
                    return tag;
                }
            }
            if (te instanceof TileEntitySteamGenerator) {
                tag.func_74757_a("active", ((TileEntitySteamGenerator)te).getHeatInput() > 0);
                tag.func_74780_a("heatD", (double)((TileEntitySteamGenerator)te).getSystemHeat());
                tag.func_74768_a("outputmb", ((TileEntitySteamGenerator)te).getOutputMB());
                tag.func_74768_a("consumption", ((TileEntitySteamGenerator)te).getInputMB());
                tag.func_74768_a("heatChange", ((TileEntitySteamGenerator)te).getHeatInput());
                FluidInfo.addTank("tank", tag, ((TileEntitySteamGenerator)te).waterTank);
                tag.func_74780_a("calcification", (double)((TileEntitySteamGenerator)te).getCalcification());
                tag.func_74768_a("pressure", ((TileEntitySteamGenerator)te).getPressure());
                return tag;
            }
            if (te instanceof TileEntityCondenser) {
                tag.func_74757_a("active", true);
                Energy energy4 = (Energy)((TileEntityCondenser)te).getComponent(Energy.class);
                tag.func_74780_a("energy", energy4.getEnergy());
                tag.func_74780_a("capacity", energy4.getCapacity());
                double d = (double)((TileEntityCondenser)te).progress * 100.0;
                ((TileEntityCondenser)te).getClass();
                tag.func_74780_a("progress", d / 10000.0);
                FluidInfo.addTank("tank", tag, ((TileEntityCondenser)te).getInputTank());
                FluidInfo.addTank("tank2", tag, ((TileEntityCondenser)te).getOutputTank());
                return tag;
            }
            if (te instanceof TileEntityFluidRegulator) {
                TileEntityFluidRegulator regulator = (TileEntityFluidRegulator)te;
                int mode = DataHelper.getInt(TileEntityFluidRegulator.class, "mode", te);
                tag.func_74757_a("active", true);
                Energy energy5 = (Energy)regulator.getComponent(Energy.class);
                tag.func_74780_a("energy", energy5.getEnergy());
                tag.func_74780_a("capacity", energy5.getCapacity());
                tag.func_74780_a("outputmb", mode == 0 ? (double)regulator.getoutputmb() / 20.0 : (double)regulator.getoutputmb());
                FluidInfo.addTank("tank", tag, regulator.getFluidTank());
                return tag;
            }
            if (te instanceof TileEntityReactorChamberElectric) {
                return this.getReactorData(((TileEntityReactorChamberElectric)te).getReactorInstance());
            }
            if (te instanceof TileEntityNuclearReactorElectric) {
                return this.getReactorData((TileEntityNuclearReactorElectric)te);
            }
            if (te instanceof TileEntityReactorVessel) {
                return this.getReactorData(((TileEntityReactorVessel)te).getReactorInstance());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean isActive(TileEntity te) {
        if (te instanceof TileEntityGeoGenerator || te instanceof TileEntityStirlingGenerator || te instanceof TileEntitySolarGenerator) {
            return ((TileEntityBlock)te).getActive();
        }
        if (te instanceof TileEntityBaseGenerator) {
            return ((TileEntityBaseGenerator)te).isConverting();
        }
        return false;
    }

    private NBTTagCompound getReactorData(TileEntityNuclearReactorElectric reactor) {
        if (reactor == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("heat", reactor.getHeat());
        tag.func_74768_a("maxHeat", reactor.getMaxHeat());
        tag.func_74757_a("active", reactor.produceEnergy());
        if (reactor.isFluidCooled()) {
            tag.func_74780_a("outputmb", (double)(reactor.EmitHeat / 20));
        } else {
            tag.func_74780_a("output", reactor.getReactorEUEnergyOutput());
        }
        TileEntityNuclearReactorElectric inventory = reactor;
        int slotCount = inventory.func_70302_i_();
        int dmgLeft = 0;
        for (int i = 0; i < slotCount; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            dmgLeft = Math.max(dmgLeft, CrossIC2Exp.getNuclearCellTimeLeft(stack));
        }
        tag.func_74768_a("timeLeft", dmgLeft * reactor.getTickRate() / 20);
        FluidInfo.addTank("tank", tag, (FluidTank)reactor.inputTank);
        FluidInfo.addTank("tank2", tag, (FluidTank)reactor.outputTank);
        return tag;
    }

    private static int getNuclearCellTimeLeft(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemReactorUranium || item instanceof ItemReactorLithiumCell) {
            return ((ICustomDamageItem)item).getMaxCustomDamage(stack) - ((ICustomDamageItem)item).getCustomDamage(stack);
        }
        if (item.getClass().getName().equals("com.sm.FirstMod.items.ItemCoaxiumRod") || item.getClass().getName().equals("com.sm.FirstMod.items.ItemCesiumRod")) {
            return stack.func_77958_k() - CrossIC2Exp.getCoaxiumDamage(stack);
        }
        return 0;
    }

    private static int getCoaxiumDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("fuelRodDamage");
    }

    @Override
    public int getHeat(World world, BlockPos pos) {
        IReactor reactor = IC2ReactorHelper.getReactorAround(world, pos);
        if (reactor != null) {
            return reactor.getHeat();
        }
        reactor = IC2ReactorHelper.getReactor3x3(world, pos);
        if (reactor != null) {
            return reactor.getHeat();
        }
        return -1;
    }

    @Override
    public ArrayList getHookValues(TileEntity te) {
        ArrayList values = IC2Hooks.map.get(te);
        if (values == null) {
            IC2Hooks.map.put(te, null);
        }
        return values;
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        if (this.getProfile() == 0) {
            ModItems.blockAfsu = ModItems.register(event, (Block)new AFSU(), "afsu");
        }
        ModItems.blockSeedAnalyzer = ModItems.register(event, (Block)new SeedAnalyzer(), "seed_analyzer");
        ModItems.blockSeedLibrary = ModItems.register(event, (Block)new SeedLibrary(), "seed_library");
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        if (this.getProfile() == 0) {
            event.getRegistry().register(new ItemAFSU(ModItems.blockAfsu).setRegistryName("afsu"));
        }
        event.getRegistry().register(new ItemBlock(ModItems.blockSeedAnalyzer).setRegistryName("seed_analyzer"));
        event.getRegistry().register(new ItemBlock(ModItems.blockSeedLibrary).setRegistryName("seed_library"));
        ModItems.itemThermometerDigital = ModItems.register(event, new ItemDigitalThermometer(), "thermometer_digital");
        if (this.getProfile() == 0) {
            ModItems.itemAFB = ModItems.register(event, (Item)new ItemAFB(), "afb");
            ModItems.itemAFSUUpgradeKit = ModItems.register(event, new ItemAFSUUpgradeKit(), "afsu_upgrade_kit");
        }
        ItemKitMain.register(ItemKitIC2::new);
        ItemCardMain.register(ItemCardIC2::new);
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        if (this.getProfile() == 0) {
            ModItems.registerBlockModel(ModItems.blockAfsu, 0, "afsu");
        }
        ModItems.registerBlockModel(ModItems.blockSeedAnalyzer, 0, "seed_analyzer");
        ModItems.registerBlockModel(ModItems.blockSeedLibrary, 0, "seed_library");
        ModItems.registerItemModel(ModItems.itemThermometerDigital, 0, "thermometer_digital");
        if (this.getProfile() == 0) {
            ModItems.registerItemModel(ModItems.itemAFB, 0, "afb");
            ModItems.registerItemModel(ModItems.itemAFSUUpgradeKit, 0, "afsu_upgrade_kit");
        }
    }

    @Override
    public void registerTileEntities() {
        if (this.getProfile() == 0) {
            GameRegistry.registerTileEntity(TileEntityAFSU.class, (String)"energycontrol:afsu");
        }
        GameRegistry.registerTileEntity(TileEntitySeedAnalyzer.class, (String)"energycontrol:seed_analyzer");
        GameRegistry.registerTileEntity(TileEntitySeedLibrary.class, (String)"energycontrol:seed_library");
    }

    @Override
    public int getProfile() {
        return ProfileManager.selected.style == Version.OLD ? 1 : 0;
    }

    @Override
    public void loadOreInfo() {
        Config config = MainConfig.get().getSub("worldgen");
        this.loadOre(BlockName.resource.getBlockState((IIdProvider)ResourceBlock.copper_ore).func_177230_c(), 1, config.getSub("copper"));
        this.loadOre(BlockName.resource.getBlockState((IIdProvider)ResourceBlock.lead_ore).func_177230_c(), 2, config.getSub("lead"));
        this.loadOre(BlockName.resource.getBlockState((IIdProvider)ResourceBlock.tin_ore).func_177230_c(), 3, config.getSub("tin"));
        this.loadOre(BlockName.resource.getBlockState((IIdProvider)ResourceBlock.uranium_ore).func_177230_c(), 4, config.getSub("uranium"));
    }

    private void loadOre(Block block, int meta, Config config) {
        EnergyControl.oreHelper.put(OreHelper.getId(block, meta), new OreHelper(ConfigUtil.getInt((Config)config, (String)"minHeight"), ConfigUtil.getInt((Config)config, (String)"maxHeight"), ConfigUtil.getInt((Config)config, (String)"size"), ConfigUtil.getInt((Config)config, (String)"count")));
    }
}

