/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.extensions.IngredientExtension;
import com.supermartijn642.core.registry.Registries;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Ingredient.class})
public class IngredientMixin
implements IngredientExtension {
    private ItemStack[] coreLibOriginalInput;

    @Inject(method={"<init>([Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void constructor(ItemStack[] input, CallbackInfo ci) {
        this.coreLibOriginalInput = input;
    }

    @Override
    public JsonElement coreLibSerialize() {
        if (this == Ingredient.field_193370_a) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "minecraft:empty");
            return json;
        }
        if (this.getClass() != Ingredient.class) {
            throw new RuntimeException("Ingredient class '" + this.getClass().getCanonicalName() + "' does not override IngredientExtension#coreLibSerialize and thus is not supported!");
        }
        if (this.coreLibOriginalInput == null || this.coreLibOriginalInput.length == 0) {
            throw new RuntimeException("Cannot serialize an empty ingredient!");
        }
        JsonArray arr = new JsonArray();
        for (ItemStack stack : this.coreLibOriginalInput) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "minecraft:item");
            json.addProperty("item", Registries.ITEMS.getIdentifier(stack.func_77973_b()).toString());
            if (stack.func_77981_g()) {
                json.addProperty("data", (Number)stack.func_77960_j());
            }
            arr.add((JsonElement)json);
        }
        return arr;
    }
}

