/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.widget.ObjectBaseContainerWidget;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public abstract class ItemBaseContainerWidget<C extends Container>
extends ObjectBaseContainerWidget<ItemStack, C> {
    protected final Supplier<ItemStack> stackSupplier;
    protected final Predicate<ItemStack> stackValidator;

    public ItemBaseContainerWidget(int x, int y, int width, int height, Supplier<ItemStack> stackSupplier, Predicate<ItemStack> stackValidator) {
        super(x, y, width, height, true);
        this.stackSupplier = stackSupplier;
        this.stackValidator = stackValidator;
    }

    public ItemBaseContainerWidget(int x, int y, int width, int height, int slotIndex, Predicate<ItemStack> stackValidator) {
        this(x, y, width, height, () -> ClientUtils.getPlayer().field_71071_by.func_70301_a(slotIndex), stackValidator);
    }

    public ItemBaseContainerWidget(int x, int y, int width, int height, int slotIndex, Item itemType) {
        this(x, y, width, height, () -> ClientUtils.getPlayer().field_71071_by.func_70301_a(slotIndex), (ItemStack stack) -> stack.func_77973_b() == itemType);
    }

    public ItemBaseContainerWidget(int x, int y, int width, int height, EnumHand hand, Predicate<ItemStack> stackValidator) {
        this(x, y, width, height, () -> ClientUtils.getPlayer().func_184586_b(hand), stackValidator);
    }

    public ItemBaseContainerWidget(int x, int y, int width, int height, EnumHand hand, Item itemType) {
        this(x, y, width, height, () -> ClientUtils.getPlayer().func_184586_b(hand), (ItemStack stack) -> stack.func_77973_b() == itemType);
    }

    @Override
    protected ItemStack getObject(ItemStack oldObject) {
        return this.stackSupplier.get();
    }

    @Override
    protected boolean validateObject(ItemStack object) {
        return object != null && this.stackValidator.test(object);
    }
}

