/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.RegistryUtil;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public abstract class ResourceGenerator {
    protected final String modid;
    protected final String modName;
    protected final ResourceCache cache;

    public ResourceGenerator(String modid, ResourceCache cache) {
        String activeMod;
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String string = activeMod = Loader.instance().activeModContainer() == null ? null : Loader.instance().activeModContainer().getModId();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + Loader.instance().activeModContainer().getName() + "' is creating a resource generator with different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a resource generator with modid '" + modid + "'!");
        }
        this.modid = modid;
        this.cache = cache;
        ModContainer container = Loader.instance().getActiveModList().stream().filter(c -> modid.equals(c.getModId())).findAny().orElse(null);
        this.modName = container == null ? modid : container.getName();
    }

    public abstract void generate();

    public void save() {
    }

    public String getName() {
        return this.modName + " Resource Generator";
    }

    public final String getOwnerModid() {
        return this.modid;
    }
}

