/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.registry.Registries;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class BaseBlockEntity
extends TileEntity {
    private final BaseBlockEntityType<?> type;
    boolean destroyedByCreativePlayer = false;
    private boolean dataChanged = true;

    public BaseBlockEntity(BaseBlockEntityType<?> type) {
        this.type = type;
        type.blockEntityClasses.add(((Object)((Object)this)).getClass());
    }

    public void dataChanged() {
        this.dataChanged = true;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getBlockState(), this.getBlockState(), 6);
    }

    protected abstract NBTTagCompound writeData();

    protected NBTTagCompound writeClientData() {
        return this.writeData();
    }

    protected NBTTagCompound writeItemStackData() {
        return this.writeData();
    }

    protected abstract void readData(NBTTagCompound var1);

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("id", Registries.BLOCK_ENTITY_TYPES.getIdentifier(this.type).toString());
        NBTTagCompound data = this.writeData();
        if (data != null && !data.func_82582_d()) {
            compound.func_74782_a("data", (NBTBase)data);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readData(nbt.func_74775_l("data"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189515_b(new NBTTagCompound());
        NBTTagCompound data = this.writeClientData();
        if (data != null && !data.func_82582_d()) {
            tag.func_74782_a("data", (NBTBase)data);
        }
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readData(tag.func_74775_l("data"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.dataChanged) {
            this.dataChanged = false;
            NBTTagCompound data = this.writeClientData();
            if (data != null && !data.func_82582_d()) {
                return new SPacketUpdateTileEntity(this.field_174879_c, 0, data);
            }
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readData(pkt.func_148857_g());
    }

    public IBlockState getBlockState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public BaseBlockEntityType<?> getType() {
        return this.type;
    }
}

